/*
 * Decompiled with CFR 0.152.
 */
package al.aldi.sprova4j.utils;

import al.aldi.sprova4j.SprovaApiClient;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ApiUtils {
    public static final String API = "/api";
    public static final String AUTHENTICATE = "/authenticate";
    public static final String PROJECTS = "projects";
    public static final String CYCLES = "cycles";
    public static final String TESTCASES = "testcases";
    public static final String EXECUTIONS = "executions";
    public static final String STEPS = "steps";
    public static final String API_PROJECTS = "/api/projects";
    public static final String API_CYCLES = "/api/cycles";
    public static final String API_TESTCASES = "/api/testcases";
    public static final String API_EXECUTIONS = "/api/executions";

    public static String sanitizeUrl(String url) throws Exception {
        String result = url;
        if (url.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            throw new Exception("Url is missing protocol. HTTPS is suggested.");
        }
        return result;
    }

    public static String post(String url, String json) throws IOException {
        RequestBody body = RequestBody.create((MediaType)SprovaApiClient.JSON, (String)json);
        Request.Builder builder = new Request.Builder().url(url).post(body);
        Request request = builder.build();
        Response response = new OkHttpClient().newCall(request).execute();
        return response.body().string();
    }
}

