/*
 * Decompiled with CFR 0.152.
 */
package al.aldi.sprova4j.utils;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(LoggingInterceptor.class);

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String body = null;
        try {
            Request copy = request.newBuilder().build();
            Buffer buffer = new Buffer();
            copy.body().writeTo((BufferedSink)buffer);
            body = buffer.readUtf8();
        }
        catch (Exception e) {
            body = "{}";
        }
        long t1 = System.nanoTime();
        logger.debug(String.format("REQ [%s] %s on %n%s %s", request.method(), request.url(), request.headers(), body));
        Response response = chain.proceed(request);
        long t2 = System.nanoTime();
        logger.debug(String.format("RES %s in %.1fms%n%s", response.request().url(), (double)(t2 - t1) / 1000000.0, response.headers()));
        return response;
    }
}

