/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl;

import java.util.Vector;
import org.apache.altrmi.client.ClientMonitor;
import org.apache.altrmi.client.ConnectionPinger;
import org.apache.altrmi.client.InterfaceLookup;
import org.apache.altrmi.client.InterfaceLookupFactory;
import org.apache.altrmi.common.ConnectionException;
import org.apache.altrmi.common.ThreadPool;

public class AbstractInterfaceLookupFactory
implements InterfaceLookupFactory {
    private Vector m_factories = new Vector();

    protected void addFactory(String factoryStringPrefix, InterfaceLookupFactory factory) {
        this.m_factories.add(new Factory(factoryStringPrefix, factory));
    }

    public final InterfaceLookup getInterfaceLookup(String factoryString, boolean optimize) throws ConnectionException {
        return this.getInterfaceLookup(factoryString, this.getClass().getClassLoader(), optimize);
    }

    public InterfaceLookup getInterfaceLookup(String factoryString, ClassLoader interfacesClassLoader, boolean optimize) throws ConnectionException {
        for (int i = 0; i < this.m_factories.size(); ++i) {
            Factory factory = (Factory)this.m_factories.elementAt(i);
            if (!factoryString.startsWith(factory.factoryStringPrefix)) continue;
            InterfaceLookup interfaceLookup = factory.interfaceLookupFactory.getInterfaceLookup(factoryString, interfacesClassLoader, optimize);
            return interfaceLookup;
        }
        return null;
    }

    public void setThreadPool(ThreadPool threadPool) {
    }

    public void setClientMonitor(ClientMonitor clientMonitor) {
    }

    public void setConnectionPinger(ConnectionPinger connectionPinger) {
    }

    private class Factory {
        private String factoryStringPrefix;
        private InterfaceLookupFactory interfaceLookupFactory;

        public Factory(String factoryStringPrefix, InterfaceLookupFactory altrmiInterfaceLookupFactory) {
            this.factoryStringPrefix = factoryStringPrefix;
            this.interfaceLookupFactory = altrmiInterfaceLookupFactory;
        }
    }
}

