/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl;

import org.apache.altrmi.client.ClientMonitor;
import org.apache.altrmi.client.ConnectionPinger;
import org.apache.altrmi.client.InterfaceLookupFactory;
import org.apache.altrmi.client.impl.AbstractInterfaceLookupFactory;
import org.apache.altrmi.client.impl.DefaultConnectionPinger;
import org.apache.altrmi.client.impl.DumbClientMonitor;
import org.apache.altrmi.common.DefaultThreadPool;
import org.apache.altrmi.common.ThreadPool;

public class DefaultInterfaceLookupFactory
extends AbstractInterfaceLookupFactory {
    public static final String[] SUPPORTEDSTREAMS = new String[]{"SocketObjectStream", "SocketCustomStream", "RMI"};
    private ThreadPool m_threadPool;
    private ClientMonitor m_clientMonitor;
    private ConnectionPinger m_connectionPinger;

    public DefaultInterfaceLookupFactory() {
        this((ThreadPool)new DefaultThreadPool(), new DumbClientMonitor(), new DefaultConnectionPinger());
    }

    public DefaultInterfaceLookupFactory(ThreadPool threadPool, ClientMonitor clientMonitor, ConnectionPinger connectionPinger) {
        InterfaceLookupFactory factory;
        this.m_threadPool = threadPool;
        this.m_connectionPinger = connectionPinger;
        this.m_clientMonitor = clientMonitor;
        try {
            factory = (InterfaceLookupFactory)this.getClass().getClassLoader().loadClass("org.apache.altrmi.client.impl.socket.SocketObjectStreamFactoryHelper").newInstance();
            factory.setClientMonitor(this.m_clientMonitor);
            factory.setConnectionPinger(this.m_connectionPinger);
            factory.setThreadPool(this.m_threadPool);
            this.addFactory("SocketObjectStream:", factory);
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            // empty catch block
        }
        try {
            factory = (InterfaceLookupFactory)this.getClass().getClassLoader().loadClass("org.apache.altrmi.client.impl.socket.SocketCustomStreamFactoryHelper").newInstance();
            factory.setClientMonitor(this.m_clientMonitor);
            factory.setConnectionPinger(this.m_connectionPinger);
            factory.setThreadPool(this.m_threadPool);
            this.addFactory("SocketCustomStream:", factory);
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (InstantiationException ie) {
        }
        catch (IllegalAccessException iae) {
            // empty catch block
        }
        try {
            factory = (InterfaceLookupFactory)Class.forName("org.apache.altrmi.client.impl.rmi.RmiFactoryHelper").newInstance();
            factory.setClientMonitor(this.m_clientMonitor);
            factory.setConnectionPinger(this.m_connectionPinger);
            factory.setThreadPool(this.m_threadPool);
            this.addFactory("RMI:", factory);
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (InstantiationException ie) {
        }
        catch (IllegalAccessException iae) {
            // empty catch block
        }
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.m_threadPool = threadPool;
    }

    public void setClientMonitor(ClientMonitor clientMonitor) {
        this.m_clientMonitor = clientMonitor;
    }

    public void setConnectionPinger(ConnectionPinger connectionPinger) {
        this.m_connectionPinger = connectionPinger;
    }
}

