/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.apache.altrmi.client.ClientContextFactory;
import org.apache.altrmi.client.ClientInvocationHandler;
import org.apache.altrmi.client.InvocationException;
import org.apache.altrmi.client.NoSuchReferenceException;
import org.apache.altrmi.client.NoSuchSessionException;
import org.apache.altrmi.client.Proxy;
import org.apache.altrmi.client.ProxyHelper;
import org.apache.altrmi.client.impl.AbstractFactory;
import org.apache.altrmi.client.impl.DefaultClientContextFactory;
import org.apache.altrmi.common.ExceptionReply;
import org.apache.altrmi.common.GarbageCollectionReply;
import org.apache.altrmi.common.GarbageCollectionRequest;
import org.apache.altrmi.common.GroupedMethodRequest;
import org.apache.altrmi.common.InvocationExceptionReply;
import org.apache.altrmi.common.MethodAsyncRequest;
import org.apache.altrmi.common.MethodFacadeArrayReply;
import org.apache.altrmi.common.MethodFacadeReply;
import org.apache.altrmi.common.MethodFacadeRequest;
import org.apache.altrmi.common.MethodReply;
import org.apache.altrmi.common.MethodRequest;
import org.apache.altrmi.common.NoSuchReferenceReply;
import org.apache.altrmi.common.NoSuchSessionReply;
import org.apache.altrmi.common.PublishedNameRequest;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.Request;

public final class DefaultProxyHelper
implements ProxyHelper {
    private final transient AbstractFactory m_factory;
    private final transient ClientInvocationHandler m_clientInvocationHandler;
    private final transient String m_publishedServiceName;
    private final transient String m_objectName;
    private final transient Long m_referenceID;
    private final transient Long m_session;
    private ClientContextFactory m_clientContextClientFactory;
    private ArrayList queuedAsyncRequests = new ArrayList();
    static /* synthetic */ Class class$java$lang$Object;

    public DefaultProxyHelper(AbstractFactory altrmiFactory, ClientInvocationHandler clientInvocationHandler, String pubishedServiceName, String objectName, Long referenceID, Long session) {
        this.m_factory = altrmiFactory;
        this.m_clientInvocationHandler = clientInvocationHandler;
        this.m_publishedServiceName = pubishedServiceName;
        this.m_objectName = objectName;
        this.m_referenceID = referenceID;
        this.m_session = session;
    }

    public void registerImplObject(Object implBean) {
        this.m_factory.registerReferenceObject(implBean, this.m_referenceID);
    }

    public Object processObjectRequestGettingFacade(Class returnClassType, String methodSignature, Object[] args, String objectName) throws Throwable {
        try {
            return this.processObjectRequestGettingFacade2(returnClassType, methodSignature, args, objectName);
        }
        catch (InvocationException ie) {
            this.m_clientInvocationHandler.getClientMonitor().invocationFailure(this.getClass(), this.getClass().getName(), ie);
            throw ie;
        }
    }

    private Object processObjectRequestGettingFacade2(Class returnClassType, String methodSignature, Object[] args, String objectName) throws Throwable {
        boolean arrayRetVal = objectName.endsWith("[]");
        String objNameWithoutArray = objectName.substring(0, objectName.length() - 2);
        MethodFacadeRequest request = arrayRetVal ? new MethodFacadeRequest(this.m_publishedServiceName, this.m_objectName, methodSignature, args, this.m_referenceID, objNameWithoutArray, this.m_session) : new MethodFacadeRequest(this.m_publishedServiceName, this.m_objectName, methodSignature, args, this.m_referenceID, objectName, this.m_session);
        this.setContext((PublishedNameRequest)request);
        Reply reply = this.m_clientInvocationHandler.handleInvocation((Request)request);
        if (reply.getReplyCode() == 5) {
            MethodFacadeReply mfr = (MethodFacadeReply)reply;
            Long ref = mfr.getReferenceID();
            if (ref == null) {
                return null;
            }
            Object implBean = this.m_factory.getImplObj(ref);
            if (implBean == null) {
                DefaultProxyHelper pHelper = new DefaultProxyHelper(this.m_factory, this.m_clientInvocationHandler, this.m_publishedServiceName, mfr.getObjectName(), ref, this.m_session);
                Object retFacade = this.m_factory.getInstance(this.m_publishedServiceName, mfr.getObjectName(), pHelper);
                pHelper.registerImplObject(retFacade);
                return retFacade;
            }
            return implBean;
        }
        if (reply.getReplyCode() == 9) {
            MethodFacadeArrayReply mfar = (MethodFacadeArrayReply)reply;
            Long[] refs = mfar.getReferenceIDs();
            String[] objectNames = mfar.getObjectNames();
            Object[] implBeans = (Object[])Array.newInstance(returnClassType, refs.length);
            for (int i = 0; i < refs.length; ++i) {
                Object o;
                Long ref = refs[i];
                if (ref == null) {
                    implBeans[i] = null;
                    continue;
                }
                implBeans[i] = o = this.m_factory.getImplObj(ref);
                if (implBeans[i] != null) continue;
                DefaultProxyHelper bo2 = new DefaultProxyHelper(this.m_factory, this.m_clientInvocationHandler, this.m_publishedServiceName, objectNames[i], refs[i], this.m_session);
                Object retFacade = null;
                try {
                    retFacade = this.m_factory.getInstance(this.m_publishedServiceName, objectNames[i], bo2);
                }
                catch (Exception e) {
                    System.out.println("objNameWithoutArray=" + returnClassType.getName());
                    System.out.flush();
                    e.printStackTrace();
                }
                bo2.registerImplObject(retFacade);
                implBeans[i] = retFacade;
            }
            return implBeans;
        }
        throw this.makeUnexpectedReplyThrowable(reply);
    }

    public Object processObjectRequest(String methodSignature, Object[] args, Class[] argClasses) throws Throwable {
        try {
            this.m_factory.marshallCorrection(methodSignature, args, argClasses);
            MethodRequest request = new MethodRequest(this.m_publishedServiceName, this.m_objectName, methodSignature, args, this.m_referenceID, this.m_session);
            this.setContext((PublishedNameRequest)request);
            Reply reply = this.m_clientInvocationHandler.handleInvocation((Request)request);
            if (reply.getReplyCode() == 2) {
                MethodReply or = (MethodReply)reply;
                return or.getReplyObject();
            }
            throw this.makeUnexpectedReplyThrowable(reply);
        }
        catch (InvocationException ie) {
            this.m_clientInvocationHandler.getClientMonitor().invocationFailure(this.getClass(), this.getClass().getName(), ie);
            throw ie;
        }
    }

    public void processVoidRequest(String methodSignature, Object[] args, Class[] argClasses) throws Throwable {
        try {
            this.m_factory.marshallCorrection(methodSignature, args, argClasses);
            MethodRequest request = new MethodRequest(this.m_publishedServiceName, this.m_objectName, methodSignature, args, this.m_referenceID, this.m_session);
            this.setContext((PublishedNameRequest)request);
            Reply reply = this.m_clientInvocationHandler.handleInvocation((Request)request);
            if (reply.getReplyCode() == 2) {
                MethodReply or = (MethodReply)reply;
                return;
            }
            throw this.makeUnexpectedReplyThrowable(reply);
        }
        catch (InvocationException ie) {
            this.m_clientInvocationHandler.getClientMonitor().invocationFailure(this.getClass(), this.getClass().getName(), ie);
            throw ie;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueAsyncRequest(String methodSignature, Object[] args, Class[] argClasses) {
        ArrayList arrayList = this.queuedAsyncRequests;
        synchronized (arrayList) {
            GroupedMethodRequest request = new GroupedMethodRequest(methodSignature, args);
            this.queuedAsyncRequests.add(request);
        }
    }

    public void commitAsyncRequests() throws Throwable {
        ArrayList arrayList = this.queuedAsyncRequests;
        synchronized (arrayList) {
            try {
                GroupedMethodRequest[] rawRequests = new GroupedMethodRequest[this.queuedAsyncRequests.size()];
                this.queuedAsyncRequests.toArray(rawRequests);
                MethodAsyncRequest request = new MethodAsyncRequest(this.m_publishedServiceName, this.m_objectName, rawRequests, this.m_referenceID, this.m_session);
                this.setContext((PublishedNameRequest)request);
                Reply reply = this.m_clientInvocationHandler.handleInvocation((Request)request);
                if (reply.getReplyCode() == 2) {
                    MethodReply or = (MethodReply)reply;
                    return;
                }
                throw this.makeUnexpectedReplyThrowable(reply);
            }
            catch (InvocationException ie) {
                this.m_clientInvocationHandler.getClientMonitor().invocationFailure(this.getClass(), this.getClass().getName(), ie);
                throw ie;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackAsyncRequests() {
        ArrayList arrayList = this.queuedAsyncRequests;
        synchronized (arrayList) {
            this.queuedAsyncRequests.clear();
        }
    }

    public void processVoidRequestWithRedirect(String methodSignature, Object[] args, Class[] argClasses) throws Throwable {
        Object[] newArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof Proxy) continue;
            newArgs[i] = args[i];
        }
        this.processVoidRequest(methodSignature, newArgs, argClasses);
    }

    private Throwable makeUnexpectedReplyThrowable(Reply reply) {
        if (reply.getReplyCode() == 3) {
            ExceptionReply er = (ExceptionReply)reply;
            return er.getReplyException();
        }
        if (reply.getReplyCode() == 110) {
            NoSuchSessionReply nssr = (NoSuchSessionReply)reply;
            return new NoSuchSessionException(nssr.getSessionID());
        }
        if (reply.getReplyCode() == 106) {
            NoSuchReferenceReply nsrr = (NoSuchReferenceReply)reply;
            return new NoSuchReferenceException(nsrr.getReferenceID());
        }
        if (reply.getReplyCode() == 109) {
            InvocationExceptionReply ier = (InvocationExceptionReply)reply;
            return new InvocationException(ier.getMessage());
        }
        return new InvocationException("Internal Error : Unknown reply type :" + reply.getClass().getName());
    }

    public Long getReferenceID(Object factory) {
        if (factory == this.m_factory) {
            return this.m_referenceID;
        }
        return null;
    }

    public boolean isEquals(Object o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        if (o1.getClass() != o2.getClass()) {
            return false;
        }
        try {
            Object retVal = this.processObjectRequest("equals(java.lang.Object)", new Object[]{o2}, new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = DefaultProxyHelper.class$("java.lang.Object")) : class$java$lang$Object});
            return (Boolean)retVal;
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            t.printStackTrace();
            throw new InvocationException("Should never get here: " + t.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        AbstractFactory abstractFactory = this.m_factory;
        synchronized (abstractFactory) {
            Reply reply = this.m_clientInvocationHandler.handleInvocation((Request)new GarbageCollectionRequest(this.m_publishedServiceName, this.m_objectName, this.m_session, this.m_referenceID));
            if (!(reply instanceof ExceptionReply) && !(reply instanceof GarbageCollectionReply)) {
                System.err.println("----> Some problem during DGC! Make sure m_factory is closed. ");
            }
        }
        super.finalize();
    }

    public void setClientContextClientFactory(ClientContextFactory clientContextClientFactory) {
        this.m_clientContextClientFactory = clientContextClientFactory;
    }

    private synchronized void setContext(PublishedNameRequest request) {
        if (this.m_clientContextClientFactory == null) {
            this.m_clientContextClientFactory = new DefaultClientContextFactory();
        }
        request.setContext(this.m_clientContextClientFactory.getClientContext());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

