/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl.betwixt;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.altrmi.client.ClientMonitor;
import org.apache.altrmi.client.ConnectionPinger;
import org.apache.altrmi.client.ConnectionRefusedException;
import org.apache.altrmi.client.impl.ClientStreamReadWriter;
import org.apache.altrmi.client.impl.betwixt.ClientBetwixtReadWriter;
import org.apache.altrmi.client.impl.stream.AbstractStreamClientInvocationHandler;
import org.apache.altrmi.common.BadConnectionException;
import org.apache.altrmi.common.ConnectionException;
import org.apache.altrmi.common.ThreadPool;

public class BetwixtInvocationHandler
extends AbstractStreamClientInvocationHandler {
    private String m_host;
    private int m_port;

    public BetwixtInvocationHandler(ThreadPool threadPool, ClientMonitor clientMonitor, ConnectionPinger connectionPinger, ClassLoader interfacesClassLoader, String host, int port) throws ConnectionRefusedException, BadConnectionException {
        super(threadPool, clientMonitor, connectionPinger, interfacesClassLoader);
        this.m_host = host;
        this.m_port = port;
        try {
            Socket socket = this.makeSocket();
            this.setObjectReadWriter(this.createClientStreamReadWriter(socket.getInputStream(), socket.getOutputStream()));
        }
        catch (IOException ioe) {
            if (ioe.getMessage().startsWith("Connection refused")) {
                throw new ConnectionRefusedException("Connection to port " + port + " on host " + host + " refused.");
            }
            throw new BadConnectionException("Cannot open Stream(s) for socket: " + ioe.getMessage());
        }
    }

    protected boolean tryReconnect() {
        return false;
    }

    private Socket makeSocket() throws IOException {
        Socket socket = new Socket(this.m_host, this.m_port);
        socket.setSoTimeout(60000);
        return socket;
    }

    protected ClientStreamReadWriter createClientStreamReadWriter(InputStream in, OutputStream out) throws ConnectionException {
        try {
            return new ClientBetwixtReadWriter(in, out, this.m_interfacesClassLoader);
        }
        catch (IntrospectionException e) {
            throw new ConnectionException("Cannot connect to server: " + e.getMessage());
        }
    }
}

