/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl.subscriber;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.altrmi.client.AbstractSubscriber;
import org.apache.altrmi.client.InterfaceLookup;
import org.apache.altrmi.client.InvocationException;
import org.apache.altrmi.client.LookupSource;
import org.apache.altrmi.common.Authentication;
import org.apache.altrmi.common.ConnectionException;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;

public abstract class AbstractSubscriberImpl
extends AbstractLogEnabled
implements Composable,
Configurable,
AbstractSubscriber {
    private int m_retryCount;
    private String m_publication;
    private LookupSource m_lookupSource;
    private Map m_subscriptions = Collections.synchronizedMap(new HashMap());

    public void compose(ComponentManager componentManager) throws ComponentException {
        this.m_lookupSource = (LookupSource)componentManager.lookup("org.apache.altrmi.client.LookupSource");
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_publication = configuration.getChild("publication").getValue();
        this.m_retryCount = configuration.getChild("retry-count").getValueAsInteger(10);
    }

    protected Object lookup(Authentication authentication) throws ConnectionException {
        for (int i = 0; i < this.m_retryCount; ++i) {
            InterfaceLookup lookup = this.m_lookupSource.get();
            try {
                InterfaceLookup dup;
                Object iface = lookup.lookup(this.m_publication, authentication);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("lookup [iface: " + iface + ", hash: " + iface.hashCode() + "]");
                }
                if ((dup = this.m_subscriptions.put(iface, lookup)) != null) {
                    this.getLogger().warn("Duplicate subscription detected [iface: " + iface + ", dup: " + dup + ", hash: " + iface.hashCode() + ", class: " + iface.getClass().getName() + "]");
                }
                return iface;
            }
            catch (InvocationException e) {
                this.getLogger().error("Exception looking up publication [pub: " + this.m_publication + "]", (Throwable)e);
                lookup.close();
                continue;
            }
        }
        return null;
    }

    public void release(Object o) {
        if (o != null) {
            InterfaceLookup lookup = (InterfaceLookup)this.m_subscriptions.remove(o);
            if (lookup == null) {
                throw new RuntimeException("Object was never subscribed [object: " + o + "]");
            }
            lookup.close();
        }
    }
}

