/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.altrmi.common.Contextualizable;
import org.apache.altrmi.common.PublishedNameRequest;

public class MethodRequest
extends PublishedNameRequest
implements Contextualizable {
    static final long serialVersionUID = -4850912985882914299L;
    private String m_methodSignature;
    private Object[] m_args;
    private Long m_referenceID;
    private Long m_session;

    public MethodRequest(String publishedServiceName, String objectName, String methodSignature, Object[] args, Long referenceID, Long session) {
        super(publishedServiceName, objectName);
        this.m_methodSignature = methodSignature;
        this.m_args = args;
        this.m_referenceID = referenceID;
        this.m_session = session;
    }

    public MethodRequest() {
    }

    public String getMethodSignature() {
        return this.m_methodSignature;
    }

    public Object[] getArgs() {
        return this.m_args;
    }

    public Long getReferenceID() {
        return this.m_referenceID;
    }

    public int getRequestCode() {
        return 302;
    }

    public Long getSession() {
        return this.m_session;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.m_methodSignature);
        out.writeObject(this.m_args);
        out.writeObject(this.m_referenceID);
        out.writeObject(this.m_session);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.m_methodSignature = (String)in.readObject();
        this.m_args = (Object[])in.readObject();
        this.m_referenceID = (Long)in.readObject();
        this.m_session = (Long)in.readObject();
    }
}

