/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import org.apache.altrmi.common.BadConnectionException;
import org.apache.altrmi.common.ConnectionException;
import org.apache.altrmi.common.EndConnectionReply;
import org.apache.altrmi.common.InvocationExceptionReply;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.Request;
import org.apache.altrmi.server.ServerConnection;
import org.apache.altrmi.server.ServerMonitor;
import org.apache.altrmi.server.impl.AbstractServer;
import org.apache.altrmi.server.impl.AbstractServerStreamReadWriter;

public abstract class AbstractStreamServerConnection
implements Runnable,
ServerConnection {
    private AbstractServer m_abstractServer;
    private boolean m_endConnection = false;
    private AbstractServerStreamReadWriter m_readWriter;
    protected final ServerMonitor m_serverMonitor;

    public AbstractStreamServerConnection(AbstractServer abstractServer, AbstractServerStreamReadWriter readWriter, ServerMonitor serverMonitor) {
        this.m_abstractServer = abstractServer;
        this.m_readWriter = readWriter;
        this.m_serverMonitor = serverMonitor;
    }

    public void run() {
        this.m_abstractServer.connectionStart(this);
        try {
            this.m_readWriter.initialize();
            boolean more = true;
            Request request = null;
            Reply reply = null;
            while (more) {
                try {
                    if (request != null) {
                        reply = this.m_abstractServer.handleInvocation(request, this.m_readWriter.getConnectionDetails());
                    }
                    request = this.m_readWriter.writeReplyAndGetRequest(reply);
                    if (!this.m_endConnection) continue;
                    reply = new EndConnectionReply();
                    more = false;
                }
                catch (BadConnectionException bce) {
                    more = false;
                    this.m_serverMonitor.badConnection(this.getClass(), "AbstractStreamServerConnection.run(): Bad connection #0", bce);
                    this.m_readWriter.close();
                }
                catch (ConnectionException ace) {
                    more = false;
                    this.m_serverMonitor.unexpectedException(this.getClass(), "AbstractStreamServerConnection.run(): Unexpected ConnectionException #0", (Exception)((Object)ace));
                    this.m_readWriter.close();
                }
                catch (IOException ioe) {
                    more = false;
                    if (ioe instanceof EOFException) {
                        this.m_readWriter.close();
                        continue;
                    }
                    if (this.isSafeEnd(ioe)) {
                        this.m_readWriter.close();
                        continue;
                    }
                    this.m_serverMonitor.unexpectedException(this.getClass(), "AbstractStreamServerConnection.run(): Unexpected IOE #1", (Exception)ioe);
                    this.m_readWriter.close();
                }
                catch (NullPointerException npe) {
                    this.m_serverMonitor.unexpectedException(this.getClass(), "AbstractStreamServerConnection.run(): Unexpected NPE", (Exception)npe);
                    reply = new InvocationExceptionReply("NullPointerException on server: " + npe.getMessage());
                }
            }
        }
        catch (IOException e) {
            this.m_serverMonitor.unexpectedException(this.getClass(), "AbstractStreamServerConnection.run(): Unexpected IOE #2", (Exception)e);
        }
        catch (ClassNotFoundException e) {
            this.m_serverMonitor.classNotFound(this.getClass(), e);
        }
        this.m_abstractServer.connectionCompleted(this);
    }

    private boolean isSafeEnd(IOException ioe) {
        String msg;
        if (ioe instanceof SocketException || ioe.getClass().getName().equals("java.net.SocketTimeoutException") || ioe instanceof InterruptedIOException) {
            return true;
        }
        return ioe.getMessage() != null && (msg = ioe.getMessage()).equals("Write end dead") | msg.equals("Pipe broken") | msg.equals("Pipe closed");
    }

    public void endConnection() {
        this.m_endConnection = true;
        this.m_readWriter.close();
    }

    protected abstract void killConnection();
}

