/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.Request;
import org.apache.altrmi.common.ThreadPool;
import org.apache.altrmi.server.ServerMonitor;
import org.apache.altrmi.server.impl.AbstractServerStreamReadWriter;

public class ServerObjectStreamReadWriter
extends AbstractServerStreamReadWriter {
    private ObjectInputStream m_objectInputStream;
    private ObjectOutputStream m_objectOutputStream;

    public ServerObjectStreamReadWriter(ServerMonitor serverMonitor, ThreadPool threadPool) {
        super(serverMonitor, threadPool);
    }

    protected void initialize() throws IOException {
        this.m_objectInputStream = new ObjectInputStream(this.getInputStream());
        this.m_objectOutputStream = new ObjectOutputStream(this.getOutputStream());
    }

    protected synchronized Request writeReplyAndGetRequest(Reply reply) throws IOException, ClassNotFoundException {
        if (reply != null) {
            this.writeReply(reply);
        }
        return this.readRequest();
    }

    private void writeReply(Reply reply) throws IOException {
        this.m_objectOutputStream.writeObject(reply);
        this.m_objectOutputStream.flush();
    }

    protected void close() {
        try {
            this.m_objectInputStream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.m_objectOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.close();
    }

    private Request readRequest() throws IOException, ClassNotFoundException {
        return (Request)this.m_objectInputStream.readObject();
    }
}

