/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl.adaptors;

import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.Request;
import org.apache.altrmi.common.SerializationHelper;
import org.apache.altrmi.server.ServerInvocationHandler;
import org.apache.altrmi.server.ServerMarshalledInvocationHandler;

public class MarshalledInvocationHandlerAdapter
implements ServerMarshalledInvocationHandler {
    private ServerInvocationHandler m_invocationHandler;
    private ClassLoader m_classLoader;

    public MarshalledInvocationHandlerAdapter(ServerInvocationHandler invocationHandler) {
        this.m_invocationHandler = invocationHandler;
        this.m_classLoader = this.getClass().getClassLoader();
    }

    public MarshalledInvocationHandlerAdapter(ServerInvocationHandler invocationHandler, ClassLoader classLoader) {
        this.m_invocationHandler = invocationHandler;
        this.m_classLoader = classLoader;
    }

    public byte[] handleInvocation(byte[] request, Object connectionDetails) {
        try {
            Request ar = (Request)SerializationHelper.getInstanceFromBytes((byte[])request, (ClassLoader)this.m_classLoader);
            Reply reply = this.m_invocationHandler.handleInvocation(ar, connectionDetails);
            return SerializationHelper.getBytesFromInstance((Object)reply);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

