/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl.betwixt;

import java.beans.IntrospectionException;
import java.io.IOException;
import org.apache.altrmi.common.ConnectionException;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.Request;
import org.apache.altrmi.common.ThreadPool;
import org.apache.altrmi.server.ServerMonitor;
import org.apache.altrmi.server.impl.AbstractServerStreamReadWriter;
import org.apache.commons.betwixt.io.BeanReader;
import org.apache.commons.betwixt.io.BeanWriter;
import org.xml.sax.SAXException;

public class ServerBetwixtReadWriter
extends AbstractServerStreamReadWriter {
    private BeanWriter beanWriter;
    private BeanReader beanReader = new BeanReader();

    public ServerBetwixtReadWriter(ServerMonitor serverMonitor, ThreadPool threadPool) {
        super(serverMonitor, threadPool);
    }

    protected void initialize() throws IOException {
        this.beanWriter = new BeanWriter(this.getOutputStream());
    }

    protected Request writeReplyAndGetRequest(Reply reply) throws IOException, ConnectionException, ClassNotFoundException {
        this.writeReply(reply);
        return this.readRequest();
    }

    private void writeReply(Reply reply) throws IOException {
        try {
            this.beanWriter.write((Object)reply);
            this.beanWriter.flush();
        }
        catch (SAXException e) {
            throw new IOException("Cannot write reply: " + e.getMessage());
        }
        catch (IntrospectionException e) {
            throw new IOException("Cannot write reply: " + e.getMessage());
        }
    }

    private Request readRequest() throws IOException {
        try {
            return (Request)this.beanReader.parse(this.getInputStream());
        }
        catch (SAXException e) {
            throw new IOException("Cannot read request: " + e.getMessage());
        }
    }
}

