/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl.messenger;

import java.io.Serializable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.altrmi.common.DefaultThreadPool;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.Request;
import org.apache.altrmi.common.ThreadContext;
import org.apache.altrmi.common.ThreadPool;
import org.apache.altrmi.server.Authenticator;
import org.apache.altrmi.server.ClassRetriever;
import org.apache.altrmi.server.ServerException;
import org.apache.altrmi.server.ServerMonitor;
import org.apache.altrmi.server.ServerSideClientContextFactory;
import org.apache.altrmi.server.impl.AbstractServer;
import org.apache.altrmi.server.impl.DefaultAuthenticator;
import org.apache.altrmi.server.impl.DefaultServerSideClientContextFactory;
import org.apache.altrmi.server.impl.NullServerMonitor;
import org.apache.altrmi.server.impl.adaptors.InvocationHandlerAdaptor;
import org.apache.altrmi.server.impl.classretrievers.NoClassRetriever;
import org.apache.altrmi.server.impl.socket.CompleteSocketObjectStreamServer;
import org.apache.commons.messenger.Messenger;

public class SynchronousMessengerServer
extends AbstractServer
implements MessageListener {
    private Messenger m_messenger;
    private String m_subject;
    private Destination m_destination;

    public SynchronousMessengerServer(ClassRetriever classRetriever, Authenticator authenticator, ServerMonitor serverMonitor, ThreadPool threadPool, ServerSideClientContextFactory contextFactory, Messenger messenger, String subject) {
        super(new InvocationHandlerAdaptor(classRetriever, authenticator, serverMonitor, contextFactory), serverMonitor, threadPool, contextFactory);
        this.m_messenger = messenger;
        this.m_subject = subject;
    }

    public void start() throws ServerException {
        try {
            this.m_destination = this.m_messenger.getDestination(this.m_subject);
            this.m_messenger.addListener(this.m_destination, (MessageListener)this);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        if (this.m_destination == null) {
            throw new ServerException("Could not find JMS destination: " + this.m_subject);
        }
    }

    public void stop() {
        try {
            this.m_messenger.removeListener(this.m_destination, (MessageListener)this);
            this.m_messenger.close();
        }
        catch (JMSException e) {
            this.m_serverMonitor.stopServerError(this.getClass(), "SynchronousMessengerServer.stop() JMSException", (Exception)((Object)e));
        }
    }

    public void onMessage(final Message message) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    if (message instanceof ObjectMessage) {
                        ObjectMessage objectMessage = (ObjectMessage)message;
                        Serializable obj = objectMessage.getObject();
                        if (obj instanceof Request) {
                            Request req = (Request)obj;
                            Reply reply = SynchronousMessengerServer.this.handleInvocation(req, "JMS:" + message.getJMSReplyTo().toString());
                            Destination dest = message.getJMSReplyTo();
                            String correlationID = message.getJMSCorrelationID();
                            ObjectMessage om = SynchronousMessengerServer.this.m_messenger.createObjectMessage((Serializable)reply);
                            om.setJMSCorrelationID(correlationID);
                            SynchronousMessengerServer.this.m_messenger.send(dest, (Message)om);
                        } else {
                            System.out.println("Invalid message!");
                        }
                    } else {
                        System.out.println("Not an ObjectMessage!");
                    }
                }
                catch (JMSException e) {
                    SynchronousMessengerServer.this.m_serverMonitor.unexpectedException(this.getClass(), "SynchronousMessengerServer.run() JMSException #1", (Exception)((Object)e));
                }
            }
        };
        ThreadContext tc = this.getThreadPool().getThreadContext(runnable);
        tc.start();
    }

    public static class WithSimpleDefaults
    extends CompleteSocketObjectStreamServer {
        public WithSimpleDefaults(int port) {
            super(new NoClassRetriever(), new DefaultAuthenticator(), new NullServerMonitor(), (ThreadPool)new DefaultThreadPool(), new DefaultServerSideClientContextFactory(), port);
        }
    }
}

