/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl.piped;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.altrmi.server.ServerMonitor;
import org.apache.altrmi.server.impl.AbstractServer;
import org.apache.altrmi.server.impl.AbstractServerStreamReadWriter;
import org.apache.altrmi.server.impl.AbstractStreamServerConnection;

public class PipedStreamServerConnection
extends AbstractStreamServerConnection {
    private PipedInputStream m_pipedIn;
    private PipedOutputStream m_pipedOut;

    public PipedStreamServerConnection(AbstractServer abstractServer, PipedInputStream pipedIn, PipedOutputStream pipedOut, AbstractServerStreamReadWriter readWriter, ServerMonitor serverMonitor) {
        super(abstractServer, readWriter, serverMonitor);
        this.m_pipedIn = pipedIn;
        this.m_pipedOut = pipedOut;
    }

    protected void killConnection() {
        try {
            this.m_pipedIn.close();
        }
        catch (IOException e) {
            this.m_serverMonitor.closeError(this.getClass(), "PipedStreamServerConnection.killConnection(): Some problem during closing of Input Stream", e);
        }
        try {
            this.m_pipedOut.close();
        }
        catch (IOException e) {
            this.m_serverMonitor.closeError(this.getClass(), "PipedStreamServerConnection.killConnection(): Some problem during closing of Output Stream", e);
        }
    }
}

