/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl.rmi;

import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.apache.altrmi.common.DefaultThreadPool;
import org.apache.altrmi.common.ThreadPool;
import org.apache.altrmi.server.Authenticator;
import org.apache.altrmi.server.ClassRetriever;
import org.apache.altrmi.server.ServerException;
import org.apache.altrmi.server.ServerMonitor;
import org.apache.altrmi.server.ServerSideClientContextFactory;
import org.apache.altrmi.server.impl.AbstractServer;
import org.apache.altrmi.server.impl.DefaultAuthenticator;
import org.apache.altrmi.server.impl.DefaultServerSideClientContextFactory;
import org.apache.altrmi.server.impl.NullServerMonitor;
import org.apache.altrmi.server.impl.adaptors.InvocationHandlerAdaptor;
import org.apache.altrmi.server.impl.classretrievers.PlainClassRetriever;
import org.apache.altrmi.server.impl.rmi.RmiInovcationAdapter;

public class RmiServer
extends AbstractServer {
    private RmiInovcationAdapter m_rmiInovcationAdapter;
    private String m_host;
    private int m_port;
    private Registry m_registry;
    static /* synthetic */ Class class$org$apache$altrmi$common$RmiInvocationHandler;

    public RmiServer(ClassRetriever classRetriever, Authenticator authenticator, ServerMonitor serverMonitor, ThreadPool threadPool, ServerSideClientContextFactory contextFactory, String host, int port) {
        super(new InvocationHandlerAdaptor(classRetriever, authenticator, serverMonitor, contextFactory), serverMonitor, threadPool, contextFactory);
        this.m_host = host;
        this.m_port = port;
    }

    public void start() throws ServerException {
        this.setState(202);
        try {
            this.m_rmiInovcationAdapter = new RmiInovcationAdapter(this);
            UnicastRemoteObject.exportObject((Remote)((Object)this.m_rmiInovcationAdapter));
            this.m_registry = LocateRegistry.createRegistry(this.m_port);
            this.m_registry.rebind((class$org$apache$altrmi$common$RmiInvocationHandler == null ? (class$org$apache$altrmi$common$RmiInvocationHandler = RmiServer.class$("org.apache.altrmi.common.RmiInvocationHandler")) : class$org$apache$altrmi$common$RmiInvocationHandler).getName(), (Remote)((Object)this.m_rmiInovcationAdapter));
            this.setState(303);
        }
        catch (RemoteException re) {
            throw new ServerException("Some problem setting up RMI server", (Throwable)re);
        }
    }

    public void stop() {
        this.setState(101);
        this.killAllConnections();
        try {
            this.m_registry.unbind((class$org$apache$altrmi$common$RmiInvocationHandler == null ? (class$org$apache$altrmi$common$RmiInvocationHandler = RmiServer.class$("org.apache.altrmi.common.RmiInvocationHandler")) : class$org$apache$altrmi$common$RmiInvocationHandler).getName());
        }
        catch (RemoteException re) {
            this.m_serverMonitor.stopServerError(this.getClass(), "RmiServer.stop(): Error stopping RMI server - RemoteException", (Exception)re);
        }
        catch (NotBoundException nbe) {
            this.m_serverMonitor.stopServerError(this.getClass(), "RmiServer.stop(): Error stopping RMI server - NotBoundException", (Exception)nbe);
        }
        this.setState(404);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class WithSimpleDefaults
    extends RmiServer {
        public WithSimpleDefaults(String host, int port) {
            super(new PlainClassRetriever(), new DefaultAuthenticator(), new NullServerMonitor(), (ThreadPool)new DefaultThreadPool(), new DefaultServerSideClientContextFactory(), host, port);
        }
    }
}

