/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl.socket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.altrmi.common.AltrmiRuntimeException;
import org.apache.altrmi.common.ThreadContext;
import org.apache.altrmi.common.ThreadPool;
import org.apache.altrmi.server.ServerException;
import org.apache.altrmi.server.ServerMonitor;
import org.apache.altrmi.server.ServerSideClientContextFactory;
import org.apache.altrmi.server.impl.AbstractServer;
import org.apache.altrmi.server.impl.AbstractServerStreamReadWriter;
import org.apache.altrmi.server.impl.adaptors.InvocationHandlerAdaptor;
import org.apache.altrmi.server.impl.socket.SocketStreamServerConnection;

public abstract class AbstractCompleteSocketStreamServer
extends AbstractServer
implements Runnable {
    private ServerSocket m_serverSocket;
    private ThreadContext m_threadContext;
    private int m_port;

    public AbstractCompleteSocketStreamServer(InvocationHandlerAdaptor invocationHandlerAdapter, ServerMonitor serverMonitor, ThreadPool threadPool, ServerSideClientContextFactory contextFactory, int port) {
        super(invocationHandlerAdapter, serverMonitor, threadPool, contextFactory);
        this.m_port = port;
    }

    public void run() {
        block3: {
            boolean accepting = false;
            try {
                while (this.getState() == 303) {
                    accepting = true;
                    Socket sock = this.m_serverSocket.accept();
                    accepting = false;
                    sock.setSoTimeout(36000);
                    AbstractServerStreamReadWriter ssrw = this.createServerStreamReadWriter();
                    ssrw.setStreams(sock.getInputStream(), sock.getOutputStream(), sock);
                    SocketStreamServerConnection sssc = new SocketStreamServerConnection(this, sock, ssrw, this.m_serverMonitor);
                    ThreadContext threadContext = this.getThreadPool().getThreadContext((Runnable)sssc);
                    threadContext.start();
                }
            }
            catch (IOException ioe) {
                if (accepting & ioe.getMessage().equals("socket closed")) break block3;
                this.m_serverMonitor.unexpectedException(this.getClass(), "AbstractCompleteSocketStreamServer.run(): Some problem connecting client via sockets: ", (Exception)ioe);
            }
        }
    }

    public void start() throws ServerException {
        this.setState(202);
        try {
            this.m_serverSocket = new ServerSocket(this.m_port);
        }
        catch (IOException ioe) {
            throw new ServerException("Could not bind to a socket when setting up the server", (Throwable)ioe);
        }
        this.setState(303);
        this.getThreadContext().start();
    }

    public void stop() {
        if (this.getState() != 303) {
            throw new AltrmiRuntimeException("Server Not Started at time of stop");
        }
        this.setState(101);
        try {
            this.m_serverSocket.close();
        }
        catch (IOException ioe) {
            throw new AltrmiRuntimeException("Error stopping Complete Socket server", (Throwable)ioe);
        }
        this.killAllConnections();
        this.getThreadContext().interrupt();
        this.setState(404);
    }

    private ThreadContext getThreadContext() {
        if (this.m_threadContext == null) {
            this.m_threadContext = this.getThreadPool().getThreadContext((Runnable)this);
        }
        return this.m_threadContext;
    }

    protected abstract AbstractServerStreamReadWriter createServerStreamReadWriter();
}

