/*
 * Decompiled with CFR 0.152.
 */
package am.ik.blog.entry;

import am.ik.blog.entry.Category;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Categories
implements Serializable {
    final List<Category> value;

    public Categories(Category ... categories) {
        this(Arrays.asList(categories));
    }

    public Categories(List<Category> value) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null!!");
        }
        this.value = value;
    }

    public Stream<Category> stream() {
        return this.value.stream();
    }

    public <A, R> R collect(Collector<Category, A, R> collector) {
        return this.value.stream().collect(collector);
    }

    public int size() {
        return this.value.size();
    }

    @JsonIgnore
    public List<Category> getValue() {
        return Collections.unmodifiableList(this.value);
    }

    @JsonProperty(value="categories")
    List<String> values() {
        return this.stream().map(Category::getValue).collect(Collectors.toList());
    }

    public String toString() {
        return this.value == null ? null : this.value.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Categories)) {
            return false;
        }
        Categories other = (Categories)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Category> this$value = this.getValue();
        List<Category> other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Categories;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Category> $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }
}

