/*
 * Decompiled with CFR 0.152.
 */
package am.ik.blog.entry;

import am.ik.blog.entry.Author;
import am.ik.blog.entry.Content;
import am.ik.blog.entry.EntryId;
import am.ik.blog.entry.FrontMatter;
import am.ik.blog.entry.json.EntryDeserializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.beans.ConstructorProperties;
import java.io.Serializable;

@JsonDeserialize(using=EntryDeserializer.class)
public class Entry
implements Serializable {
    @JsonUnwrapped
    final EntryId entryId;
    @JsonUnwrapped
    final Content content;
    final Author created;
    final Author updated;
    final FrontMatter frontMatter;

    public EntryBuilder copy() {
        return Entry.builder().entryId(this.entryId).content(this.content).created(this.created).updated(this.updated).frontMatter(this.frontMatter);
    }

    public Entry useFrontMatterDate() {
        EntryBuilder builder = this.copy();
        if (this.frontMatter != null && this.frontMatter.date != null && this.frontMatter.date.value != null && this.created != null) {
            builder.created(new Author(this.created.name, this.frontMatter.date));
        }
        if (this.frontMatter != null && this.frontMatter.updated != null && this.frontMatter.updated.value != null && this.updated != null) {
            builder.updated(new Author(this.updated.name, this.frontMatter.updated));
        }
        return builder.build();
    }

    @JsonIgnore
    public boolean isPremium() {
        return this.frontMatter.point.isPremium();
    }

    public static boolean isPublicFileName(String fileName) {
        return fileName.matches("[0-9]+\\.md");
    }

    public EntryId entryId() {
        return this.entryId;
    }

    public Content content() {
        return this.content;
    }

    public FrontMatter frontMatter() {
        return this.frontMatter;
    }

    public static EntryBuilder builder() {
        return new EntryBuilder();
    }

    @ConstructorProperties(value={"entryId", "content", "created", "updated", "frontMatter"})
    public Entry(EntryId entryId, Content content, Author created, Author updated, FrontMatter frontMatter) {
        this.entryId = entryId;
        this.content = content;
        this.created = created;
        this.updated = updated;
        this.frontMatter = frontMatter;
    }

    public String toString() {
        return "Entry(entryId=" + this.getEntryId() + ", content=" + this.getContent() + ", created=" + this.getCreated() + ", updated=" + this.getUpdated() + ", frontMatter=" + this.getFrontMatter() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Entry)) {
            return false;
        }
        Entry other = (Entry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntryId this$entryId = this.getEntryId();
        EntryId other$entryId = other.getEntryId();
        if (this$entryId == null ? other$entryId != null : !((Object)this$entryId).equals(other$entryId)) {
            return false;
        }
        Content this$content = this.getContent();
        Content other$content = other.getContent();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        Author this$created = this.getCreated();
        Author other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Author this$updated = this.getUpdated();
        Author other$updated = other.getUpdated();
        if (this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated)) {
            return false;
        }
        FrontMatter this$frontMatter = this.getFrontMatter();
        FrontMatter other$frontMatter = other.getFrontMatter();
        return !(this$frontMatter == null ? other$frontMatter != null : !((Object)this$frontMatter).equals(other$frontMatter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Entry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntryId $entryId = this.getEntryId();
        result = result * 59 + ($entryId == null ? 43 : ((Object)$entryId).hashCode());
        Content $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        Author $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Author $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        FrontMatter $frontMatter = this.getFrontMatter();
        result = result * 59 + ($frontMatter == null ? 43 : ((Object)$frontMatter).hashCode());
        return result;
    }

    public EntryId getEntryId() {
        return this.entryId;
    }

    public Content getContent() {
        return this.content;
    }

    public Author getCreated() {
        return this.created;
    }

    public Author getUpdated() {
        return this.updated;
    }

    public FrontMatter getFrontMatter() {
        return this.frontMatter;
    }

    public static class EntryBuilder {
        private EntryId entryId;
        private Content content;
        private Author created;
        private Author updated;
        private FrontMatter frontMatter;

        EntryBuilder() {
        }

        public EntryBuilder entryId(EntryId entryId) {
            this.entryId = entryId;
            return this;
        }

        public EntryBuilder content(Content content) {
            this.content = content;
            return this;
        }

        public EntryBuilder created(Author created) {
            this.created = created;
            return this;
        }

        public EntryBuilder updated(Author updated) {
            this.updated = updated;
            return this;
        }

        public EntryBuilder frontMatter(FrontMatter frontMatter) {
            this.frontMatter = frontMatter;
            return this;
        }

        public Entry build() {
            return new Entry(this.entryId, this.content, this.created, this.updated, this.frontMatter);
        }

        public String toString() {
            return "Entry.EntryBuilder(entryId=" + this.entryId + ", content=" + this.content + ", created=" + this.created + ", updated=" + this.updated + ", frontMatter=" + this.frontMatter + ")";
        }
    }
}

