/*
 * Decompiled with CFR 0.152.
 */
package am.ik.blog.entry;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;

public class EventTime
implements Serializable {
    public static EventTime UNSET = new EventTime(null){

        @Override
        public String toString() {
            return "";
        }
    };
    @JsonProperty(value="date")
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    final OffsetDateTime value;

    public static EventTime now() {
        return new EventTime(OffsetDateTime.now());
    }

    @JsonIgnore
    public boolean isSet() {
        return this.value != null;
    }

    public String toString() {
        return this.value == null ? null : this.value.toString();
    }

    @JsonIgnore
    public boolean isOverHalfYearOld() {
        return this.isOld(6L, ChronoUnit.MONTHS);
    }

    @JsonIgnore
    public boolean isOverOneYearOld() {
        return this.isOld(1L, ChronoUnit.YEARS);
    }

    @JsonIgnore
    public boolean isOverThreeYearsOld() {
        return this.isOld(3L, ChronoUnit.YEARS);
    }

    @JsonIgnore
    public boolean isOverFiveYearsOld() {
        return this.isOld(5L, ChronoUnit.YEARS);
    }

    private boolean isOld(long amount, TemporalUnit unit) {
        return this.value.plus(amount, unit).isBefore(OffsetDateTime.now());
    }

    @ConstructorProperties(value={"value"})
    public EventTime(OffsetDateTime value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventTime)) {
            return false;
        }
        EventTime other = (EventTime)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OffsetDateTime this$value = this.getValue();
        OffsetDateTime other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventTime;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OffsetDateTime $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    public OffsetDateTime getValue() {
        return this.value;
    }
}

