/*
 * Decompiled with CFR 0.152.
 */
package am.ik.blog.entry;

import am.ik.blog.entry.Tag;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Tags
implements Serializable {
    final List<Tag> value;

    public Tags(Tag ... tags) {
        this(Arrays.asList(tags));
    }

    public Tags(List<Tag> value) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null!!");
        }
        this.value = value;
    }

    public Stream<Tag> stream() {
        return this.value.stream();
    }

    public <A, R> R collect(Collector<Tag, A, R> collector) {
        return this.value.stream().collect(collector);
    }

    public int size() {
        return this.value.size();
    }

    @JsonIgnore
    public List<Tag> getValue() {
        return Collections.unmodifiableList(this.value);
    }

    @JsonProperty(value="tags")
    List<String> values() {
        return this.stream().map(Tag::getValue).collect(Collectors.toList());
    }

    public String toString() {
        return this.value == null ? null : this.value.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tags)) {
            return false;
        }
        Tags other = (Tags)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Tag> this$value = this.getValue();
        List<Tag> other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Tags;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Tag> $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }
}

