/*
 * Decompiled with CFR 0.152.
 */
package am.ik.blog.entry.factory;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Emoji {
    private static final Pattern pattern = Pattern.compile("((([\ud83c\udf00-\ud83d\uddff]|[\ud83d\ude00-\ud83d\ude4f]|[\ud83d\ude80-\ud83d\udeff]|[\u2600-\u26ff]|[\u2700-\u27bf])[\\x{1F3FB}-\\x{1F3FF}]?))");
    public static String PROTOCOL = "https:";
    public static String BASE = "//twemoji.maxcdn.com/";
    public static String SIZE = "16x16";
    public static String EXTENSION = ".png";
    public static String CLASSNAME = "emoji";

    public static String parse(String text) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = pattern.matcher(text);
        String iconUrl = null;
        while (matcher.find()) {
            String rawCode = matcher.group(2);
            String iconId = Emoji.grabTheRightIcon(rawCode);
            iconUrl = PROTOCOL + BASE + SIZE + "/" + iconId + EXTENSION;
            matcher.appendReplacement(sb, "<img class=\"" + CLASSNAME + "\" draggable=\"false\" src=\"" + iconUrl + "\">");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String toCodePoint(String unicodeSurrogates, String sep) {
        ArrayList<String> r = new ArrayList<String>();
        char c = '\u0000';
        int p = 0;
        int i = 0;
        if (sep == null) {
            sep = "-";
        }
        while (i < unicodeSurrogates.length()) {
            c = unicodeSurrogates.charAt(i++);
            if (p != 0) {
                r.add(Integer.toString(65536 + (p - 55296 << 10) + (c - 56320), 16));
                p = 0;
                continue;
            }
            if ('\ud800' <= c && c <= '\udbff') {
                p = c;
                continue;
            }
            r.add(Integer.toString(c, 16));
        }
        return r.stream().collect(Collectors.joining(sep));
    }

    private static String grabTheRightIcon(String rawText) {
        return Emoji.toCodePoint(rawText.indexOf(8205) < 0 ? rawText.replace("\ufe0f", "") : rawText, null);
    }
}

