/*
 * Decompiled with CFR 0.152.
 */
package am.ik.blog.entry.factory;

import am.ik.blog.entry.Content;
import am.ik.blog.entry.Entry;
import am.ik.blog.entry.EntryId;
import am.ik.blog.entry.FrontMatter;
import am.ik.blog.entry.factory.Emoji;
import am.ik.blog.entry.factory.FrontMatterFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.springframework.core.io.Resource;
import org.yaml.snakeyaml.Yaml;

public class EntryFactory {
    final Yaml yaml;
    final FrontMatterFactory frontMatterFactory;

    public EntryFactory() {
        this(new Yaml());
    }

    public EntryFactory(Yaml yaml) {
        this.yaml = yaml;
        this.frontMatterFactory = new FrontMatterFactory(yaml);
    }

    static boolean isPublic(Resource file) {
        return file != null && Entry.isPublicFileName(file.getFilename());
    }

    static EntryId parseEntryId(Resource file) {
        return EntryId.fromFileName(file.getFilename());
    }

    public Optional<Entry.EntryBuilder> parseBody(EntryId entryId, InputStream body) {
        return this.parseBody(entryId, new InputStreamReader(body, StandardCharsets.UTF_8));
    }

    public Optional<Entry.EntryBuilder> parseBody(EntryId entryId, String body) {
        return this.parseBody(entryId, new StringReader(body));
    }

    private Optional<Entry.EntryBuilder> parseBody(EntryId entryId, Reader r) {
        BufferedReader reader = new BufferedReader(r);
        Entry.EntryBuilder entryBuilder = Entry.builder();
        entryBuilder.entryId(entryId);
        try {
            StringBuilder out = new StringBuilder();
            String firstLine = reader.readLine();
            if ("---".equals(firstLine)) {
                String line = reader.readLine();
                while (line != null && !"---".equals(line)) {
                    out.append(line);
                    out.append(System.lineSeparator());
                    line = reader.readLine();
                }
            } else {
                return Optional.empty();
            }
            String yaml = out.toString();
            FrontMatter frontMatter = this.frontMatterFactory.createFromYaml(yaml);
            entryBuilder.frontMatter(frontMatter);
            out = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                out.append(line);
                out.append(System.lineSeparator());
                line = reader.readLine();
            }
            String content = out.toString().trim();
            entryBuilder.content(new Content(Emoji.parse(content)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return Optional.of(entryBuilder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Entry.EntryBuilder> createFromYamlFile(Resource file) {
        if (!EntryFactory.isPublic(file)) {
            return Optional.empty();
        }
        EntryId entryId = EntryFactory.parseEntryId(file);
        try (InputStream stream = file.getInputStream();){
            Optional<Entry.EntryBuilder> optional = this.parseBody(entryId, stream);
            return optional;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

