/*
 * Decompiled with CFR 0.152.
 */
package am.ik.blog.entry.factory;

import am.ik.blog.entry.Categories;
import am.ik.blog.entry.Category;
import am.ik.blog.entry.EventTime;
import am.ik.blog.entry.FrontMatter;
import am.ik.blog.entry.PremiumPoint;
import am.ik.blog.entry.Tag;
import am.ik.blog.entry.Tags;
import am.ik.blog.entry.Title;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.Yaml;

class FrontMatterFactory {
    private final Yaml yaml;

    public FrontMatter createFromYaml(String string) {
        Map map = (Map)this.yaml.load(string);
        Title title = new Title(map.getOrDefault("title", "no title"));
        Categories categories = new Categories(((List)map.computeIfAbsent("categories", key -> Collections.emptyList())).stream().map(Category::new).collect(Collectors.toList()));
        Tags tags = new Tags(((List)map.computeIfAbsent("tags", key -> Collections.emptyList())).stream().map(Tag::new).collect(Collectors.toList()));
        EventTime date = map.containsKey("date") ? new EventTime(OffsetDateTime.ofInstant(((Date)map.get("date")).toInstant(), ZoneId.systemDefault())) : EventTime.UNSET;
        EventTime updated = map.containsKey("updated") ? new EventTime(OffsetDateTime.ofInstant(((Date)map.get("updated")).toInstant(), ZoneId.systemDefault())) : EventTime.UNSET;
        PremiumPoint point = map.containsKey("point") ? new PremiumPoint((Integer)map.get("point")) : PremiumPoint.UNSET;
        return new FrontMatter(title, categories, tags, date, updated, point);
    }

    @ConstructorProperties(value={"yaml"})
    public FrontMatterFactory(Yaml yaml) {
        this.yaml = yaml;
    }
}

