/*
 * Decompiled with CFR 0.152.
 */
package am.ik.blog.entry.json;

import am.ik.blog.entry.Categories;
import am.ik.blog.entry.Category;
import am.ik.blog.entry.EventTime;
import am.ik.blog.entry.FrontMatter;
import am.ik.blog.entry.PremiumPoint;
import am.ik.blog.entry.Tag;
import am.ik.blog.entry.Tags;
import am.ik.blog.entry.Title;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.boot.jackson.JsonObjectDeserializer;

public class FrontMatterDeserializer
extends JsonObjectDeserializer<FrontMatter> {
    protected FrontMatter deserializeObject(JsonParser jsonParser, DeserializationContext deserializationContext, ObjectCodec objectCodec, JsonNode jsonNode) throws IOException {
        Title title = new Title((String)this.nullSafeValue(jsonNode.get("title"), String.class));
        Tags tags = new Tags(StreamSupport.stream(jsonNode.get("tags").spliterator(), false).map(n -> new Tag(n.asText())).collect(Collectors.toList()));
        Categories categories = new Categories(StreamSupport.stream(jsonNode.get("categories").spliterator(), false).map(n -> new Category(n.asText())).collect(Collectors.toList()));
        PremiumPoint point = new PremiumPoint((Integer)this.nullSafeValue(jsonNode.get("point"), Integer.class));
        return new FrontMatter(title, categories, tags, EventTime.UNSET, EventTime.UNSET, point);
    }
}

