/*
 * Decompiled with CFR 0.152.
 */
package am.ik.categolj3.api;

import am.ik.categolj3.api.category.CategoryService;
import am.ik.categolj3.api.category.InMemoryCategoryService;
import am.ik.categolj3.api.jest.JestProperties;
import am.ik.categolj3.api.tag.InMemoryTagService;
import am.ik.categolj3.api.tag.TagService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import java.text.DateFormat;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@ComponentScan
@EnableCaching
@EnableAsync
@EnableScheduling
public class CategoLJ3ApiConfig {
    @Bean
    @ConditionalOnMissingBean
    JestClient jestClient(JestProperties jestProperties) {
        JestClientFactory factory = new JestClientFactory();
        factory.setHttpClientConfig(((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)new HttpClientConfig.Builder(jestProperties.getConnectionUrl()).multiThreaded(true)).connTimeout(jestProperties.getConnectionTimeout())).readTimeout(jestProperties.getReadTimeout())).gson(this.gson())).build());
        return factory.getObject();
    }

    @Bean
    Gson gson() {
        return new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssX").registerTypeAdapter(OffsetDateTime.class, (json, type, context) -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)json.getAsString(), OffsetDateTime::from)).registerTypeAdapter(OffsetDateTime.class, (json, type, context) -> new JsonPrimitive(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format((TemporalAccessor)json))).create();
    }

    @Bean
    @ConditionalOnMissingBean
    ObjectMapper objectMapper() {
        return new Jackson2ObjectMapperBuilder().dateFormat((DateFormat)new StdDateFormat()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    TagService tagService() {
        return new InMemoryTagService();
    }

    @Bean
    @ConditionalOnMissingBean
    CategoryService categoryService() {
        return new InMemoryCategoryService();
    }
}

