/*
 * Decompiled with CFR 0.152.
 */
package am.ik.categolj3.api.category;

import am.ik.categolj3.api.category.CategoryService;
import am.ik.categolj3.api.entry.Entry;
import am.ik.categolj3.api.event.EntryEvictEvent;
import am.ik.categolj3.api.event.EntryPutEvent;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.util.CollectionUtils;

public class InMemoryCategoryService
implements CategoryService {
    private static final Logger log = LoggerFactory.getLogger(InMemoryCategoryService.class);
    private final ConcurrentMap<Long, List<String>> categories = new ConcurrentHashMap<Long, List<String>>();

    @EventListener
    public void handlePutEntry(EntryPutEvent.Bulk event) {
        if (log.isInfoEnabled()) {
            log.info("bulk put ({})", (Object)event.getEvents().size());
        }
        this.categories.putAll(event.getEvents().stream().map(EntryPutEvent::getEntry).filter(e -> !CollectionUtils.isEmpty(e.getFrontMatter().getCategories())).collect(Collectors.toMap(Entry::getEntryId, e -> e.getFrontMatter().getCategories())));
    }

    @EventListener
    public void handleEvictEntry(EntryEvictEvent.Bulk event) {
        if (log.isInfoEnabled()) {
            log.info("bulk evict ({})", (Object)event.getEvents().size());
        }
        event.getEvents().forEach(e -> {
            List cfr_ignored_0 = (List)this.categories.remove(e.getEntryId());
        });
    }

    @Override
    public List<List<String>> findAllOrderByNameAsc() {
        return this.categories.values().stream().distinct().sorted(Comparator.comparing(categories -> String.join((CharSequence)",", categories))).collect(Collectors.toList());
    }
}

