/*
 * Decompiled with CFR 0.152.
 */
package am.ik.categolj3.api.entry;

import am.ik.categolj3.api.entry.Author;
import am.ik.categolj3.api.entry.FrontMatter;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.searchbox.annotations.JestId;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;

public class Entry
implements Serializable {
    public static final String INDEX_NAME = "entries";
    public static final String DOC_TYPE = "entry";
    @JestId
    private Long entryId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String content;
    private Author created;
    private Author updated;
    private FrontMatter frontMatter;

    public static boolean isPublic(Path file) {
        return file != null && file.toFile().getName().matches("[0-9]+\\.md");
    }

    public static Long parseEntryId(Path file) {
        String entryId = file.toFile().getName().replace(".md", "");
        return Long.valueOf(entryId);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<Entry> loadFromFile(Path file) {
        if (!Entry.isPublic(file)) {
            return Optional.empty();
        }
        try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
            StringBuilder out;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            Entry entry = new Entry();
            entry.setEntryId(Entry.parseEntryId(file));
            try {
                out = new StringBuilder();
                String firstLine = reader.readLine();
                if ("---".equals(firstLine)) {
                    String line = reader.readLine();
                    while (line != null && !"---".equals(line)) {
                        out.append(line);
                        out.append(System.lineSeparator());
                        line = reader.readLine();
                    }
                } else {
                    Optional<Entry> optional = Optional.empty();
                    return optional;
                }
                entry.setFrontMatter(FrontMatter.loadFromYamlString(out.toString()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            {
                out = new StringBuilder();
                String line = reader.readLine();
                while (line != null) {
                    out.append(line);
                    out.append(System.lineSeparator());
                    line = reader.readLine();
                }
                entry.setContent(out.toString().trim());
            }
            Optional<Entry> optional = Optional.of(entry);
            return optional;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static EntryBuilder builder() {
        return new EntryBuilder();
    }

    public Long getEntryId() {
        return this.entryId;
    }

    public String getContent() {
        return this.content;
    }

    public Author getCreated() {
        return this.created;
    }

    public Author getUpdated() {
        return this.updated;
    }

    public FrontMatter getFrontMatter() {
        return this.frontMatter;
    }

    public void setEntryId(Long entryId) {
        this.entryId = entryId;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setCreated(Author created) {
        this.created = created;
    }

    public void setUpdated(Author updated) {
        this.updated = updated;
    }

    public void setFrontMatter(FrontMatter frontMatter) {
        this.frontMatter = frontMatter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Entry)) {
            return false;
        }
        Entry other = (Entry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$entryId = this.getEntryId();
        Long other$entryId = other.getEntryId();
        if (this$entryId == null ? other$entryId != null : !((Object)this$entryId).equals(other$entryId)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Author this$created = this.getCreated();
        Author other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Author this$updated = this.getUpdated();
        Author other$updated = other.getUpdated();
        if (this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated)) {
            return false;
        }
        FrontMatter this$frontMatter = this.getFrontMatter();
        FrontMatter other$frontMatter = other.getFrontMatter();
        return !(this$frontMatter == null ? other$frontMatter != null : !((Object)this$frontMatter).equals(other$frontMatter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Entry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entryId = this.getEntryId();
        result = result * 59 + ($entryId == null ? 43 : ((Object)$entryId).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Author $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Author $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        FrontMatter $frontMatter = this.getFrontMatter();
        result = result * 59 + ($frontMatter == null ? 43 : ((Object)$frontMatter).hashCode());
        return result;
    }

    public String toString() {
        return "Entry(entryId=" + this.getEntryId() + ", content=" + this.getContent() + ", created=" + this.getCreated() + ", updated=" + this.getUpdated() + ", frontMatter=" + this.getFrontMatter() + ")";
    }

    public Entry() {
    }

    @ConstructorProperties(value={"entryId", "content", "created", "updated", "frontMatter"})
    public Entry(Long entryId, String content, Author created, Author updated, FrontMatter frontMatter) {
        this.entryId = entryId;
        this.content = content;
        this.created = created;
        this.updated = updated;
        this.frontMatter = frontMatter;
    }

    public static class EntryBuilder {
        private Long entryId;
        private String content;
        private Author created;
        private Author updated;
        private FrontMatter frontMatter;

        EntryBuilder() {
        }

        public EntryBuilder entryId(Long entryId) {
            this.entryId = entryId;
            return this;
        }

        public EntryBuilder content(String content) {
            this.content = content;
            return this;
        }

        public EntryBuilder created(Author created) {
            this.created = created;
            return this;
        }

        public EntryBuilder updated(Author updated) {
            this.updated = updated;
            return this;
        }

        public EntryBuilder frontMatter(FrontMatter frontMatter) {
            this.frontMatter = frontMatter;
            return this;
        }

        public Entry build() {
            return new Entry(this.entryId, this.content, this.created, this.updated, this.frontMatter);
        }

        public String toString() {
            return "Entry.EntryBuilder(entryId=" + this.entryId + ", content=" + this.content + ", created=" + this.created + ", updated=" + this.updated + ", frontMatter=" + this.frontMatter + ")";
        }
    }
}

