/*
 * Decompiled with CFR 0.152.
 */
package am.ik.categolj3.api.entry;

import am.ik.categolj3.api.entry.Entry;
import am.ik.categolj3.api.event.EntryEvictEvent;
import am.ik.categolj3.api.event.EntryPutEvent;
import am.ik.categolj3.api.event.EventManager;
import org.springframework.cache.Cache;

public class EntryEventFiringCache
implements Cache {
    private final Cache delegate;
    private final EventManager eventManager;

    public EntryEventFiringCache(Cache delegate, EventManager eventManager) {
        this.delegate = delegate;
        this.eventManager = eventManager;
    }

    public void clear() {
        this.delegate.clear();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public Object getNativeCache() {
        return this.delegate.getNativeCache();
    }

    public Cache.ValueWrapper get(Object key) {
        return this.delegate.get(key);
    }

    public <T> T get(Object key, Class<T> type) {
        return (T)this.delegate.get(key, type);
    }

    public void put(Object key, Object value) {
        this.delegate.put(key, value);
        this.eventManager.registerEntryPutEvent(new EntryPutEvent((Entry)value));
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Cache.ValueWrapper wrapper = this.delegate.putIfAbsent(key, value);
        if (wrapper == null) {
            this.eventManager.registerEntryPutEvent(new EntryPutEvent((Entry)value));
        }
        return wrapper;
    }

    public void evict(Object key) {
        this.delegate.evict(key);
        this.eventManager.registerEntryEvictEvent(new EntryEvictEvent((Long)key));
    }
}

