/*
 * Decompiled with CFR 0.152.
 */
package am.ik.categolj3.api.entry;

import am.ik.categolj3.api.entry.Entry;
import am.ik.categolj3.api.entry.EntryProperties;
import am.ik.categolj3.api.entry.EntryService;
import am.ik.categolj3.api.entry.SearchEntryOperations;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"api"})
public class EntryRestController {
    @Autowired
    EntryService entryService;
    @Autowired
    EntryProperties entryProperties;
    final SearchEntryOperations.SearchOptions excludeContentOption = SearchEntryOperations.SearchOptions.builder().excludeContent(true).build();

    @RequestMapping(path={"entries"}, method={RequestMethod.GET})
    Page<Entry> getEntries(@PageableDefault Pageable pageable, @RequestParam(defaultValue="false") boolean excludeContent) {
        return excludeContent ? this.entryService.findAll(pageable, this.excludeContentOption) : this.entryService.findAll(pageable);
    }

    @RequestMapping(path={"entries"}, method={RequestMethod.GET}, params={"q"})
    Page<Entry> searchEntries(@PageableDefault Pageable pageable, @RequestParam String q, @RequestParam(defaultValue="false") boolean excludeContent) {
        return excludeContent ? this.entryService.findByQuery(q, pageable, this.excludeContentOption) : this.entryService.findByQuery(q, pageable);
    }

    @RequestMapping(path={"users/{createdBy}/entries"}, method={RequestMethod.GET})
    Page<Entry> getEntriesByCreatedBy(@PageableDefault Pageable pageable, @PathVariable String createdBy, @RequestParam(defaultValue="false") boolean excludeContent) {
        return excludeContent ? this.entryService.findByCreatedBy(createdBy, pageable, this.excludeContentOption) : this.entryService.findByCreatedBy(createdBy, pageable);
    }

    @RequestMapping(path={"users/{updatedBy}/entries"}, method={RequestMethod.GET}, params={"updated"})
    Page<Entry> getEntriesByUpdatedBy(@PageableDefault Pageable pageable, @PathVariable String updatedBy, @RequestParam(defaultValue="false") boolean excludeContent) {
        return excludeContent ? this.entryService.findByUpdatedBy(updatedBy, pageable, this.excludeContentOption) : this.entryService.findByUpdatedBy(updatedBy, pageable);
    }

    @RequestMapping(path={"tags/{tag}/entries"}, method={RequestMethod.GET})
    Page<Entry> getEntriesByTag(@PageableDefault Pageable pageable, @PathVariable String tag, @RequestParam(defaultValue="false") boolean excludeContent) {
        return excludeContent ? this.entryService.findByTag(tag, pageable, this.excludeContentOption) : this.entryService.findByTag(tag, pageable);
    }

    @RequestMapping(path={"categories/{categories}/entries"}, method={RequestMethod.GET})
    Page<Entry> getEntriesByCategories(@PageableDefault Pageable pageable, @PathVariable String categories, @RequestParam(defaultValue="false") boolean excludeContent) {
        List<String> c = Splitter.on((String)this.entryProperties.getCategoriesSeparator()).trimResults().omitEmptyStrings().splitToList((CharSequence)categories).stream().map(String::toLowerCase).collect(Collectors.toList());
        return excludeContent ? this.entryService.findByCategories(c, pageable, this.excludeContentOption) : this.entryService.findByCategories(c, pageable);
    }

    @RequestMapping(path={"entries/{entryId}"}, method={RequestMethod.GET})
    Entry getEntry(@PathVariable Long entryId) {
        return this.entryService.findOne(entryId);
    }
}

