/*
 * Decompiled with CFR 0.152.
 */
package am.ik.categolj3.api.entry;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class FrontMatter
implements Serializable {
    private String title;
    private List<String> tags;
    private List<String> categories;
    @JsonIgnore
    private transient OffsetDateTime date;
    @JsonIgnore
    private transient OffsetDateTime updated;
    private static final Yaml yaml = new Yaml();
    static final String SEPARATOR = "---";

    public static FrontMatter loadFromYamlString(String string) {
        Map map = (Map)yaml.load(string);
        FrontMatter frontMatter = new FrontMatter();
        frontMatter.setTitle(map.getOrDefault("title", "no title"));
        frontMatter.setTags((List)map.computeIfAbsent("tags", key -> Collections.emptyList()));
        frontMatter.setCategories((List)map.computeIfAbsent("categories", key -> Collections.emptyList()));
        if (map.containsKey("date")) {
            frontMatter.setDate(OffsetDateTime.ofInstant(((Date)map.get("date")).toInstant(), ZoneId.systemDefault()));
        }
        if (map.containsKey("updated")) {
            frontMatter.setUpdated(OffsetDateTime.ofInstant(((Date)map.get("updated")).toInstant(), ZoneId.systemDefault()));
        }
        return frontMatter;
    }

    public static FrontMatterBuilder builder() {
        return new FrontMatterBuilder();
    }

    public String getTitle() {
        return this.title;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public OffsetDateTime getDate() {
        return this.date;
    }

    public OffsetDateTime getUpdated() {
        return this.updated;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public void setDate(OffsetDateTime date) {
        this.date = date;
    }

    public void setUpdated(OffsetDateTime updated) {
        this.updated = updated;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FrontMatter)) {
            return false;
        }
        FrontMatter other = (FrontMatter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<String> this$categories = this.getCategories();
        List<String> other$categories = other.getCategories();
        return !(this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FrontMatter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<String> $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
        return result;
    }

    public String toString() {
        return "FrontMatter(title=" + this.getTitle() + ", tags=" + this.getTags() + ", categories=" + this.getCategories() + ", date=" + this.getDate() + ", updated=" + this.getUpdated() + ")";
    }

    public FrontMatter() {
    }

    @ConstructorProperties(value={"title", "tags", "categories", "date", "updated"})
    public FrontMatter(String title, List<String> tags, List<String> categories, OffsetDateTime date, OffsetDateTime updated) {
        this.title = title;
        this.tags = tags;
        this.categories = categories;
        this.date = date;
        this.updated = updated;
    }

    public static class FrontMatterBuilder {
        private String title;
        private List<String> tags;
        private List<String> categories;
        private OffsetDateTime date;
        private OffsetDateTime updated;

        FrontMatterBuilder() {
        }

        public FrontMatterBuilder title(String title) {
            this.title = title;
            return this;
        }

        public FrontMatterBuilder tags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public FrontMatterBuilder categories(List<String> categories) {
            this.categories = categories;
            return this;
        }

        public FrontMatterBuilder date(OffsetDateTime date) {
            this.date = date;
            return this;
        }

        public FrontMatterBuilder updated(OffsetDateTime updated) {
            this.updated = updated;
            return this;
        }

        public FrontMatter build() {
            return new FrontMatter(this.title, this.tags, this.categories, this.date, this.updated);
        }

        public String toString() {
            return "FrontMatter.FrontMatterBuilder(title=" + this.title + ", tags=" + this.tags + ", categories=" + this.categories + ", date=" + this.date + ", updated=" + this.updated + ")";
        }
    }
}

