/*
 * Decompiled with CFR 0.152.
 */
package am.ik.categolj3.api.entry;

import am.ik.categolj3.api.entry.Entry;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public interface SearchEntryOperations {
    public Page<Entry> findAll(Pageable var1, SearchOptions var2);

    default public Page<Entry> findAll(Pageable pageable) {
        return this.findAll(pageable, SearchOptions.DEFAULT);
    }

    public Page<Entry> findByTag(String var1, Pageable var2, SearchOptions var3);

    default public Page<Entry> findByTag(String tag, Pageable pageable) {
        return this.findByTag(tag, pageable, SearchOptions.DEFAULT);
    }

    public Page<Entry> findByCategories(List<String> var1, Pageable var2, SearchOptions var3);

    default public Page<Entry> findByCategories(List<String> categories, Pageable pageable) {
        return this.findByCategories(categories, pageable, SearchOptions.DEFAULT);
    }

    public Page<Entry> findByCreatedBy(String var1, Pageable var2, SearchOptions var3);

    default public Page<Entry> findByCreatedBy(String user, Pageable pageable) {
        return this.findByCreatedBy(user, pageable, SearchOptions.DEFAULT);
    }

    public Page<Entry> findByUpdatedBy(String var1, Pageable var2, SearchOptions var3);

    default public Page<Entry> findByUpdatedBy(String user, Pageable pageable) {
        return this.findByUpdatedBy(user, pageable, SearchOptions.DEFAULT);
    }

    public Page<Entry> findByQuery(String var1, Pageable var2, SearchOptions var3);

    default public Page<Entry> findByQuery(String q, Pageable pageable) {
        return this.findByQuery(q, pageable, SearchOptions.DEFAULT);
    }

    public static class SearchOptions {
        private boolean excludeContent;
        public static final SearchOptions DEFAULT = SearchOptions.builder().excludeContent(false).build();

        SearchOptions(boolean excludeContent) {
            this.excludeContent = excludeContent;
        }

        public static SearchOptionsBuilder builder() {
            return new SearchOptionsBuilder();
        }

        public boolean isExcludeContent() {
            return this.excludeContent;
        }

        public void setExcludeContent(boolean excludeContent) {
            this.excludeContent = excludeContent;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SearchOptions)) {
                return false;
            }
            SearchOptions other = (SearchOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isExcludeContent() == other.isExcludeContent();
        }

        protected boolean canEqual(Object other) {
            return other instanceof SearchOptions;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isExcludeContent() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "SearchEntryOperations.SearchOptions(excludeContent=" + this.isExcludeContent() + ")";
        }

        public static class SearchOptionsBuilder {
            private boolean excludeContent;

            SearchOptionsBuilder() {
            }

            public SearchOptionsBuilder excludeContent(boolean excludeContent) {
                this.excludeContent = excludeContent;
                return this;
            }

            public SearchOptions build() {
                return new SearchOptions(this.excludeContent);
            }

            public String toString() {
                return "SearchEntryOperations.SearchOptions.SearchOptionsBuilder(excludeContent=" + this.excludeContent + ")";
            }
        }
    }
}

