/*
 * Decompiled with CFR 0.152.
 */
package am.ik.categolj3.api.entry.redis;

import am.ik.categolj3.api.entry.Entry;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Arrays;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class EntryRedisTemplateFactory {
    final RedisConnectionFactory redisConnectionFactory;
    final ObjectMapper objectMapper;

    public RedisTemplate<Object, Object> create() {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(this.redisConnectionFactory);
        template.setKeySerializer((RedisSerializer)new JdkSerializationRedisSerializer());
        template.setValueSerializer((RedisSerializer)new RedisSerializer<Entry>(){

            public byte[] serialize(Entry entry) throws SerializationException {
                if (entry == null) {
                    return new byte[0];
                }
                try {
                    return EntryRedisTemplateFactory.this.objectMapper.writeValueAsBytes((Object)entry);
                }
                catch (JsonProcessingException e) {
                    throw new SerializationException("Cannot serialize " + entry, (Throwable)e);
                }
            }

            public Entry deserialize(byte[] bytes) throws SerializationException {
                if (bytes == null || bytes.length == 0) {
                    return null;
                }
                try {
                    return (Entry)EntryRedisTemplateFactory.this.objectMapper.readValue(bytes, Entry.class);
                }
                catch (IOException e) {
                    throw new SerializationException("Cannot deserialize " + Arrays.toString(bytes), (Throwable)e);
                }
            }
        });
        return template;
    }

    @ConstructorProperties(value={"redisConnectionFactory", "objectMapper"})
    public EntryRedisTemplateFactory(RedisConnectionFactory redisConnectionFactory, ObjectMapper objectMapper) {
        this.redisConnectionFactory = redisConnectionFactory;
        this.objectMapper = objectMapper;
    }

    public RedisConnectionFactory getRedisConnectionFactory() {
        return this.redisConnectionFactory;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntryRedisTemplateFactory)) {
            return false;
        }
        EntryRedisTemplateFactory other = (EntryRedisTemplateFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RedisConnectionFactory this$redisConnectionFactory = this.getRedisConnectionFactory();
        RedisConnectionFactory other$redisConnectionFactory = other.getRedisConnectionFactory();
        if (this$redisConnectionFactory == null ? other$redisConnectionFactory != null : !this$redisConnectionFactory.equals(other$redisConnectionFactory)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        return !(this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntryRedisTemplateFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RedisConnectionFactory $redisConnectionFactory = this.getRedisConnectionFactory();
        result = result * 59 + ($redisConnectionFactory == null ? 43 : $redisConnectionFactory.hashCode());
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        return result;
    }

    public String toString() {
        return "EntryRedisTemplateFactory(redisConnectionFactory=" + this.getRedisConnectionFactory() + ", objectMapper=" + this.getObjectMapper() + ")";
    }
}

