/*
 * Decompiled with CFR 0.152.
 */
package am.ik.categolj3.api.event;

import am.ik.categolj3.api.event.AppState;
import am.ik.categolj3.api.event.EntryEvictEvent;
import am.ik.categolj3.api.event.EntryPutEvent;
import am.ik.categolj3.api.event.EntryReIndexEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class EventManager {
    private static final Logger log = LoggerFactory.getLogger(EventManager.class);
    final ApplicationEventPublisher publisher;
    final Queue<EntryEvictEvent> entryEvictEventQueue = new ConcurrentLinkedDeque<EntryEvictEvent>();
    final Queue<EntryPutEvent> entryPutEventQueue = new ConcurrentLinkedDeque<EntryPutEvent>();
    final Queue<AppState> appStateQueue = new ConcurrentLinkedDeque<AppState>();
    private final AtomicReference<AppState> state = new AtomicReference<AppState>(AppState.INITIALIZING);

    @Autowired
    public EventManager(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Scheduled(fixedRate=5000L)
    public void fireEvents() {
        ArrayList<EntryEvictEvent> entryEvictEvents = new ArrayList<EntryEvictEvent>();
        while (!this.entryEvictEventQueue.isEmpty()) {
            entryEvictEvents.add(this.entryEvictEventQueue.poll());
        }
        if (!entryEvictEvents.isEmpty()) {
            log.info("publish bulk evict event");
            this.publisher.publishEvent((Object)new EntryEvictEvent.Bulk((List<EntryEvictEvent>)entryEvictEvents));
        }
        ArrayList<EntryPutEvent> entryPutEvents = new ArrayList<EntryPutEvent>();
        while (!this.entryPutEventQueue.isEmpty()) {
            entryPutEvents.add(this.entryPutEventQueue.poll());
        }
        if (!entryPutEvents.isEmpty()) {
            log.info("publish bulk put event");
            this.publisher.publishEvent((Object)new EntryPutEvent.Bulk((List<EntryPutEvent>)entryPutEvents));
        }
        while (!this.appStateQueue.isEmpty()) {
            AppState state = this.appStateQueue.poll();
            if (state == AppState.INITIALIZED) {
                log.info("Initialized");
            }
            this.state.set(state);
        }
    }

    public void registerEntryEvictEvent(EntryEvictEvent event) {
        this.entryEvictEventQueue.add(event);
    }

    public void registerEntryPutEvent(EntryPutEvent event) {
        this.entryPutEventQueue.add(event);
    }

    public void registerEntryReindexEvent(EntryReIndexEvent event) {
        this.publisher.publishEvent((Object)event);
    }

    public void setState(AppState state) {
        this.appStateQueue.add(state);
    }

    public AppState getState() {
        return this.state.get();
    }
}

