/*
 * Decompiled with CFR 0.152.
 */
package am.ik.categolj3.api.git;

import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="git")
public class GitProperties {
    @NotNull
    private File baseDir;
    @NotEmpty
    private String contentDir;
    @NotEmpty
    private String uri;
    private boolean init = false;
    private String username;
    private char[] password;

    public Optional<UsernamePasswordCredentialsProvider> credentialsProvider() {
        if (this.username == null || this.password == null) {
            return Optional.empty();
        }
        return Optional.of(new UsernamePasswordCredentialsProvider(this.username, this.password));
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public String getContentDir() {
        return this.contentDir;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isInit() {
        return this.init;
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setContentDir(String contentDir) {
        this.contentDir = contentDir;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setInit(boolean init) {
        this.init = init;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitProperties)) {
            return false;
        }
        GitProperties other = (GitProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$baseDir = this.getBaseDir();
        File other$baseDir = other.getBaseDir();
        if (this$baseDir == null ? other$baseDir != null : !((Object)this$baseDir).equals(other$baseDir)) {
            return false;
        }
        String this$contentDir = this.getContentDir();
        String other$contentDir = other.getContentDir();
        if (this$contentDir == null ? other$contentDir != null : !this$contentDir.equals(other$contentDir)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        if (this.isInit() != other.isInit()) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        return Arrays.equals(this.getPassword(), other.getPassword());
    }

    protected boolean canEqual(Object other) {
        return other instanceof GitProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $baseDir = this.getBaseDir();
        result = result * 59 + ($baseDir == null ? 43 : ((Object)$baseDir).hashCode());
        String $contentDir = this.getContentDir();
        result = result * 59 + ($contentDir == null ? 43 : $contentDir.hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        result = result * 59 + (this.isInit() ? 79 : 97);
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        return result;
    }

    public String toString() {
        return "GitProperties(baseDir=" + this.getBaseDir() + ", contentDir=" + this.getContentDir() + ", uri=" + this.getUri() + ", init=" + this.isInit() + ", username=" + this.getUsername() + ")";
    }
}

