/*
 * Decompiled with CFR 0.152.
 */
package am.ik.categolj3.api.git;

import am.ik.categolj3.api.entry.Author;
import am.ik.categolj3.api.entry.Entry;
import am.ik.categolj3.api.entry.EntryEventFiringCache;
import am.ik.categolj3.api.event.AppState;
import am.ik.categolj3.api.event.EventManager;
import am.ik.categolj3.api.git.GitProperties;
import com.google.common.collect.Iterables;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.FileSystemUtils;

@Component
public class GitStore {
    private static final Logger log = LoggerFactory.getLogger(GitStore.class);
    @Autowired
    GitProperties gitProperties;
    @Autowired
    CacheManager cacheManager;
    @Autowired
    EventManager eventManager;
    @Autowired
    ForceRefreshTask forceRefreshTask;
    @Autowired
    GitPullTask gitPullTask;
    @Autowired
    ApplicationContext applicationContext;
    Cache entryCache;
    Git git;
    AtomicReference<ObjectId> currentHead = new AtomicReference();

    public Entry get(Long entryId) {
        Entry entry = (Entry)this.entryCache.get((Object)entryId, Entry.class);
        if (entry == null) {
            entry = this.getContentFiles().stream().filter(f -> String.format("%05d.md", entryId).equals(f.getName())).map(File::toPath).map(Entry::loadFromFile).filter(Optional::isPresent).map(Optional::get).findAny().orElseThrow(() -> new IllegalArgumentException("The requested entry is not found [" + entryId + "]"));
            this.entryCache.put((Object)entryId, (Object)entry);
        }
        return entry;
    }

    public CompletableFuture<PullResult> pull() {
        return this.gitPullTask.pull(this.git).thenApply(x -> {
            this.syncHead();
            return x;
        });
    }

    public List<Entry> loadEntries() {
        return this.getContentFiles().stream().map(File::toPath).map(this::loadEntry).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public void forceRefreshAll() {
        this.loadEntries().forEach(entry -> this.entryCache.put((Object)entry.getEntryId(), entry));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncHead() {
        log.info("Syncing HEAD...");
        ObjectId oldHead = this.currentHead.get();
        ObjectId newHead = this.head();
        try (Repository repository = this.git.getRepository();){
            DiffFormatter diffFormatter = new DiffFormatter((OutputStream)System.out);
            diffFormatter.setRepository(repository);
            RevWalk walk = new RevWalk(repository);
            try {
                RevCommit fromCommit = walk.parseCommit((AnyObjectId)oldHead);
                RevCommit toCommit = walk.parseCommit((AnyObjectId)newHead);
                List list = diffFormatter.scan(fromCommit.getTree(), toCommit.getTree());
                list.forEach(diff -> {
                    Path path;
                    log.info("[{}]\tnew={}\told={}", new Object[]{diff.getChangeType(), diff.getNewPath(), diff.getOldPath()});
                    if (diff.getOldPath() != null && Entry.isPublic(path = Paths.get(this.gitProperties.getBaseDir().getAbsolutePath() + "/" + diff.getOldPath(), new String[0]))) {
                        Long entryId = Entry.parseEntryId(path);
                        log.info("evict Entry({})", (Object)entryId);
                        this.entryCache.evict((Object)entryId);
                    }
                    if (diff.getNewPath() != null) {
                        path = Paths.get(this.gitProperties.getBaseDir().getAbsolutePath() + "/" + diff.getNewPath(), new String[0]);
                        this.loadEntry(path).ifPresent(entry -> {
                            log.info("put Entry({})", (Object)entry.getEntryId());
                            this.entryCache.put((Object)entry.getEntryId(), entry);
                        });
                    }
                });
            }
            finally {
                walk.dispose();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.currentHead.set(newHead);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ObjectId head() {
        try (Repository repository = this.git.getRepository();){
            ObjectId objectId = repository.resolve("HEAD");
            return objectId;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    Optional<Entry> loadEntry(Path path) {
        return Entry.loadFromFile(path).map(e -> {
            Pair<Author, Author> author = this.getAuthor(path);
            if (e.getFrontMatter() != null && e.getFrontMatter().getDate() != null) {
                e.setCreated(new Author(author.getKey().getName(), e.getFrontMatter().getDate()));
            } else {
                e.setCreated(author.getKey());
            }
            if (e.getFrontMatter() != null && e.getFrontMatter().getUpdated() != null) {
                e.setUpdated(new Author(author.getValue().getName(), e.getFrontMatter().getUpdated()));
            } else {
                e.setUpdated(author.getValue());
            }
            return e;
        });
    }

    List<File> getContentFiles() {
        String contentsDir = this.gitProperties.getBaseDir().getAbsolutePath() + "/" + this.gitProperties.getContentDir();
        File[] files = new File(contentsDir).listFiles(f -> Entry.isPublic(f.toPath()));
        return files == null ? Collections.emptyList() : Arrays.asList(files);
    }

    Pair<Author, Author> getAuthor(Path path) {
        Path p = this.gitProperties.getBaseDir().toPath().relativize(path);
        try {
            Iterable commits = this.git.log().addPath(p.toString().replace("\\", "/")).call();
            RevCommit updated = (RevCommit)Iterables.getFirst((Iterable)commits, null);
            RevCommit created = (RevCommit)Iterables.getLast((Iterable)commits, (Object)updated);
            return new Pair<Author, Author>(this.author(created), this.author(updated));
        }
        catch (GitAPIException e) {
            throw new IllegalStateException(e);
        }
    }

    Author author(RevCommit commit) {
        String name = commit != null ? commit.getAuthorIdent().getName() : "";
        Date date = commit != null ? commit.getAuthorIdent().getWhen() : new Date();
        OffsetDateTime o = OffsetDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        return new Author(name, o);
    }

    Git getGitDirectory() {
        try {
            if (this.gitProperties.getBaseDir().exists()) {
                if (this.gitProperties.isInit()) {
                    FileSystemUtils.deleteRecursively((File)this.gitProperties.getBaseDir());
                } else {
                    return Git.open((File)this.gitProperties.getBaseDir());
                }
            }
            CloneCommand clone = Git.cloneRepository().setURI(this.gitProperties.getUri()).setDirectory(this.gitProperties.getBaseDir());
            this.gitProperties.credentialsProvider().ifPresent(arg_0 -> ((CloneCommand)clone).setCredentialsProvider(arg_0));
            return clone.call();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (GitAPIException e) {
            throw new IllegalStateException(e);
        }
    }

    @PostConstruct
    void load() {
        this.entryCache = new EntryEventFiringCache(this.cacheManager.getCache("entry"), this.eventManager);
        this.git = this.getGitDirectory();
        this.currentHead.set(this.head());
        ((CompletableFuture)((CompletableFuture)this.pull().thenCompose(r -> this.forceRefreshTask.forceRefresh(this))).thenAccept(v -> this.eventManager.setState(AppState.INITIALIZED))).exceptionally(e -> {
            log.error("error!", e);
            return null;
        });
    }

    @PreDestroy
    void destroy() {
        this.git.close();
    }

    public static class Pair<K, V> {
        private final K key;
        private final V value;

        @ConstructorProperties(value={"key", "value"})
        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            K this$key = this.getKey();
            K other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            V this$value = this.getValue();
            V other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Pair;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            K $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            V $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "GitStore.Pair(key=" + this.getKey() + ", value=" + this.getValue() + ")";
        }
    }

    @Component
    public static class GitPullTask {
        private static final Logger log = LoggerFactory.getLogger(GitPullTask.class);
        @Autowired
        GitProperties gitProperties;

        @Async
        public CompletableFuture<PullResult> pull(Git git) {
            log.info("git pull {}", (Object)this.gitProperties.getUri());
            try {
                PullCommand pull = git.pull();
                this.gitProperties.credentialsProvider().ifPresent(arg_0 -> ((PullCommand)pull).setCredentialsProvider(arg_0));
                return CompletableFuture.completedFuture(pull.call());
            }
            catch (GitAPIException e) {
                CompletableFuture<PullResult> f = new CompletableFuture<PullResult>();
                f.completeExceptionally(e);
                return f;
            }
        }
    }

    @Component
    public static class ForceRefreshTask {
        private static final Logger log = LoggerFactory.getLogger(ForceRefreshTask.class);

        @Async
        public CompletableFuture<Void> forceRefresh(GitStore gitStore) {
            try {
                gitStore.forceRefreshAll();
                return CompletableFuture.completedFuture(null);
            }
            catch (Exception e) {
                CompletableFuture<Void> f = new CompletableFuture<Void>();
                f.completeExceptionally(e);
                return f;
            }
        }
    }
}

