/*
 * Decompiled with CFR 0.152.
 */
package am.ik.categolj3.api.jest;

import am.ik.categolj3.api.entry.Entry;
import am.ik.categolj3.api.git.GitStore;
import io.searchbox.action.Action;
import io.searchbox.action.BulkableAction;
import io.searchbox.client.JestClient;
import io.searchbox.core.Bulk;
import io.searchbox.core.Delete;
import io.searchbox.core.Index;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class JestIndexer {
    private static final Logger log = LoggerFactory.getLogger(JestIndexer.class);
    @Autowired
    GitStore gitStore;
    @Autowired
    JestClient jestClient;

    @Async
    public CompletableFuture<Void> reindex() {
        log.info("re-indexing ...");
        List<Entry> entries = this.gitStore.loadEntries();
        Bulk.Builder bulkBuilder = new Bulk.Builder();
        for (Entry entry : entries) {
            Index index = ((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)entry).refresh(true)).index("entries")).type("entry")).build();
            bulkBuilder.addAction((BulkableAction)index);
        }
        try {
            this.jestClient.execute((Action)bulkBuilder.build());
            log.info("re-indexed!");
            return CompletableFuture.completedFuture(null);
        }
        catch (Exception e) {
            CompletableFuture<Void> f = new CompletableFuture<Void>();
            f.completeExceptionally(e);
            return f;
        }
    }

    public void bulkDelete(List<Long> deleteIds) throws Exception {
        Bulk.Builder bulkBuilder = new Bulk.Builder();
        for (Long id : deleteIds) {
            Delete delete = ((Delete.Builder)((Delete.Builder)((Delete.Builder)new Delete.Builder(id.toString()).refresh(true)).index("entries")).type("entry")).build();
            bulkBuilder.addAction((BulkableAction)delete);
        }
        this.jestClient.execute((Action)bulkBuilder.build());
    }

    public void bulkUpdate(List<Entry> updateEntries) throws Exception {
        Bulk.Builder bulkBuilder = new Bulk.Builder();
        for (Entry entry : updateEntries) {
            Index index = ((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)entry).refresh(true)).index("entries")).type("entry")).build();
            bulkBuilder.addAction((BulkableAction)index);
        }
        this.jestClient.execute((Action)bulkBuilder.build());
    }
}

