/*
 * Decompiled with CFR 0.152.
 */
package am.ik.categolj3.api.jest;

import am.ik.categolj3.api.entry.Entry;
import am.ik.categolj3.api.entry.SearchEntryOperations;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.core.Count;
import io.searchbox.core.CountResult;
import io.searchbox.core.Search;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.IndicesExists;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.SimpleQueryStringBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class JestSearchEntryOperations
implements SearchEntryOperations {
    private static final Logger log = LoggerFactory.getLogger(JestSearchEntryOperations.class);
    @Autowired
    JestClient jestClient;
    final String[] fieldsExcludeContent = new String[]{"entryId", "created.name", "created.date", "updated.name", "updated.date", "frontMatter.title", "frontMatter.tags", "frontMatter.categories"};

    @Override
    public Page<Entry> findAll(Pageable pageable, SearchEntryOperations.SearchOptions options) {
        MatchAllQueryBuilder query = QueryBuilders.matchAllQuery();
        return this.search((QueryBuilder)query, pageable, options);
    }

    @Override
    public Page<Entry> findByTag(String tag, Pageable pageable, SearchEntryOperations.SearchOptions options) {
        MatchQueryBuilder query = QueryBuilders.matchQuery((String)"frontMatter.tags", (Object)tag).operator(MatchQueryBuilder.Operator.AND);
        return this.search((QueryBuilder)query, pageable, options);
    }

    @Override
    public Page<Entry> findByCategories(List<String> categories, Pageable pageable, SearchEntryOperations.SearchOptions options) {
        MatchQueryBuilder query = QueryBuilders.matchQuery((String)"frontMatter.categories", categories).operator(MatchQueryBuilder.Operator.AND);
        return this.search((QueryBuilder)query, pageable, options);
    }

    @Override
    public Page<Entry> findByCreatedBy(String user, Pageable pageable, SearchEntryOperations.SearchOptions options) {
        MatchQueryBuilder query = QueryBuilders.matchQuery((String)"created.name", (Object)user).operator(MatchQueryBuilder.Operator.AND);
        return this.search((QueryBuilder)query, pageable, options);
    }

    @Override
    public Page<Entry> findByUpdatedBy(String user, Pageable pageable, SearchEntryOperations.SearchOptions options) {
        MatchQueryBuilder query = QueryBuilders.matchQuery((String)"updated.name", (Object)user).operator(MatchQueryBuilder.Operator.AND);
        return this.search((QueryBuilder)query, pageable, options);
    }

    @Override
    public Page<Entry> findByQuery(String q, Pageable pageable, SearchEntryOperations.SearchOptions options) {
        SimpleQueryStringBuilder query = QueryBuilders.simpleQueryStringQuery((String)q);
        return this.search((QueryBuilder)query, pageable, options);
    }

    Page<Entry> search(QueryBuilder query, Pageable pageable, SearchEntryOperations.SearchOptions options) {
        try {
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query(query).sort("updated.date", SortOrder.DESC).sort("entryId", SortOrder.DESC).from(pageable.getOffset()).size(pageable.getPageSize());
            if (options.isExcludeContent()) {
                sourceBuilder = sourceBuilder.fetchSource(this.fieldsExcludeContent, new String[]{"content"});
            }
            long count = ((CountResult)this.jestClient.execute((Action)((Count.Builder)((Count.Builder)new Count.Builder().query(new SearchSourceBuilder().query(query).toString()).addIndex("entries")).addType("entry")).build())).getCount().longValue();
            List content = null;
            content = count > 0L ? this.jestClient.execute((Action)((Search.Builder)((Search.Builder)new Search.Builder(sourceBuilder.toString()).addIndex("entries")).addType("entry")).build()).getSourceAsObjectList(Entry.class) : Collections.emptyList();
            return new PageImpl(content, pageable, count);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @PostConstruct
    void init() throws Exception {
        IndicesExists indicesExists = new IndicesExists.Builder("entries").build();
        JestResult result = this.jestClient.execute((Action)indicesExists);
        if (!result.isSucceeded()) {
            log.info("Create index {} ...", (Object)"entries");
            CreateIndex createIndex = new CreateIndex.Builder("entries").build();
            String json = this.jestClient.execute((Action)createIndex).getJsonString();
            log.info("Created index {}", (Object)json);
        }
    }
}

