/*
 * Decompiled with CFR 0.152.
 */
package am.ik.categolj3.api.jest;

import am.ik.categolj3.api.event.AppState;
import am.ik.categolj3.api.event.EntryEvictEvent;
import am.ik.categolj3.api.event.EntryPutEvent;
import am.ik.categolj3.api.event.EntryReIndexEvent;
import am.ik.categolj3.api.event.EventManager;
import am.ik.categolj3.api.jest.JestIndexer;
import am.ik.categolj3.api.jest.JestProperties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class JestSync {
    private static final Logger log = LoggerFactory.getLogger(JestSync.class);
    @Autowired
    JestIndexer indexer;
    @Autowired
    JestProperties jestProperties;
    @Autowired
    EventManager eventManager;

    @EventListener
    public void handleBulkDelete(EntryEvictEvent.Bulk e) {
        AppState state = this.eventManager.getState();
        if (state == AppState.INITIALIZED || this.jestProperties.isInit()) {
            if (log.isInfoEnabled()) {
                log.info("Bulk delete ({})", (Object)e.getEvents().size());
            }
            try {
                this.indexer.bulkDelete(e.getEvents().stream().map(EntryEvictEvent::getEntryId).collect(Collectors.toList()));
            }
            catch (Exception ex) {
                log.warn("Failed to bulk delete", (Throwable)ex);
                e.getEvents().forEach(this.eventManager::registerEntryEvictEvent);
            }
        } else if (log.isInfoEnabled()) {
            log.info("Skip to bulk delete (status={},jest.init={})", (Object)state, (Object)this.jestProperties.isInit());
        }
    }

    @EventListener
    public void handleBulkUpdate(EntryPutEvent.Bulk e) {
        AppState state = this.eventManager.getState();
        if (state == AppState.INITIALIZED || this.jestProperties.isInit()) {
            if (log.isInfoEnabled()) {
                log.info("Bulk update ({})", (Object)e.getEvents().size());
            }
            try {
                this.indexer.bulkUpdate(e.getEvents().stream().map(EntryPutEvent::getEntry).collect(Collectors.toList()));
            }
            catch (Exception ex) {
                log.warn("Failed to bulk update", (Throwable)ex);
                e.getEvents().forEach(this.eventManager::registerEntryPutEvent);
            }
        } else if (log.isInfoEnabled()) {
            log.info("Skip to bulk update (status={},jest.init={})", (Object)state, (Object)this.jestProperties.isInit());
        }
    }

    @EventListener
    public void handleReindex(EntryReIndexEvent e) {
        this.indexer.reindex();
    }
}

