/*
 * Decompiled with CFR 0.152.
 */
package am.ik.categolj3.api.tag;

import am.ik.categolj3.api.entry.Entry;
import am.ik.categolj3.api.event.EntryEvictEvent;
import am.ik.categolj3.api.event.EntryPutEvent;
import am.ik.categolj3.api.tag.TagService;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.util.CollectionUtils;

public class InMemoryTagService
implements TagService {
    private static final Logger log = LoggerFactory.getLogger(InMemoryTagService.class);
    private final ConcurrentMap<Long, List<String>> tags = new ConcurrentHashMap<Long, List<String>>();

    @EventListener
    public void handlePutEntry(EntryPutEvent.Bulk event) {
        if (log.isInfoEnabled()) {
            log.info("bulk put ({})", (Object)event.getEvents().size());
        }
        this.tags.putAll(event.getEvents().stream().map(EntryPutEvent::getEntry).filter(e -> !CollectionUtils.isEmpty(e.getFrontMatter().getTags())).collect(Collectors.toMap(Entry::getEntryId, e -> e.getFrontMatter().getTags())));
    }

    @EventListener
    public void handleEvictEntry(EntryEvictEvent.Bulk event) {
        if (log.isInfoEnabled()) {
            log.info("bulk evict ({})", (Object)event.getEvents().size());
        }
        event.getEvents().forEach(e -> {
            List cfr_ignored_0 = (List)this.tags.remove(e.getEntryId());
        });
    }

    @Override
    public List<String> findAllOrderByNameAsc() {
        return this.tags.values().stream().flatMap(Collection::stream).distinct().sorted().collect(Collectors.toList());
    }
}

