package am.ik.servicebroker.cloudkarafka.config;

import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.http.SessionCreationPolicy;

@Configuration
public class SecurityConfig extends WebSecurityConfigurerAdapter {

	@Override
	protected void configure(HttpSecurity http) throws Exception {
		http.authorizeRequests() //
				.mvcMatchers("/actuator/health").permitAll()
				.requestMatchers(EndpointRequest.toAnyEndpoint()).hasRole("ADMIN") //
				.mvcMatchers("/v2/**").hasRole("ADMIN") //
				.and() //
				.httpBasic() //
				.and() //
				.csrf().disable() //
				.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.NEVER);
	}
}
