/*
 * Decompiled with CFR 0.152.
 */
package am.ik.servicebroker.cloudkarafka.servicebroker;

import am.ik.servicebroker.cloudkarafka.cloudkarafka.CloudKarafkaClient;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/service_instances/{instanceId}/service_bindings/{bindingId}"})
public class ServiceInstanceBindingController {
    private static final Logger log = LoggerFactory.getLogger(ServiceInstanceBindingController.class);
    private final CloudKarafkaClient cloudKarafkaClient;

    public ServiceInstanceBindingController(CloudKarafkaClient cloudKarafkaClient) {
        this.cloudKarafkaClient = cloudKarafkaClient;
    }

    @PutMapping
    public ResponseEntity<Map<String, Object>> bind(@PathVariable(value="instanceId") String instanceId, @PathVariable(value="bindingId") String bindingId) {
        log.info("bind instanceId={}, bindingId={}", (Object)instanceId, (Object)bindingId);
        String name = "cf_" + instanceId;
        HashMap body = new HashMap();
        this.cloudKarafkaClient.findByName(name).ifPresent(i -> body.put("credentials", i.credential()));
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body(body);
    }

    @DeleteMapping
    public ResponseEntity<Map<String, Object>> unbind(@PathVariable(value="instanceId") String instanceId, @PathVariable(value="bindingId") String bindingId) {
        log.info("unbind instanceId={}, bindingId={}", (Object)instanceId, (Object)bindingId);
        HashMap body = new HashMap();
        return ResponseEntity.ok(body);
    }
}

