/*
 * Decompiled with CFR 0.152.
 */
package am.ik.servicebroker.cloudkarafka.servicebroker;

import am.ik.servicebroker.cloudkarafka.cloudkarafka.CloudKarafkaClient;
import am.ik.servicebroker.cloudkarafka.cloudkarafka.CloudKarafkaInstance;
import am.ik.servicebroker.cloudkarafka.cloudkarafka.CloudKarafkaPlan;
import am.ik.servicebroker.cloudkarafka.cloudkarafka.CloudKarafkaRegion;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/service_instances/{instanceId}"})
public class ServiceInstanceController {
    private static final Logger log = LoggerFactory.getLogger(ServiceInstanceController.class);
    private final CloudKarafkaClient cloudKarafkaClient;

    public ServiceInstanceController(CloudKarafkaClient cloudKarafkaClient) {
        this.cloudKarafkaClient = cloudKarafkaClient;
    }

    @PutMapping
    public ResponseEntity<Map<String, Object>> provisioning(@PathVariable(value="instanceId") String instanceId) {
        log.info("Provisioning instanceId={}", (Object)instanceId);
        String name = "cf_" + instanceId;
        CloudKarafkaPlan plan = CloudKarafkaPlan.DUCKY;
        CloudKarafkaRegion region = CloudKarafkaRegion.GOOGLE_COMPUTE_ENGINE_US_CENTRAL1;
        CloudKarafkaInstance instance = this.cloudKarafkaClient.createInstance(name, plan, region);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("dashboard_url", String.format("https://customer.cloudkarafka.com/instance/%d/sso", instance.getId()));
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body(body);
    }

    @PatchMapping
    public ResponseEntity<Map<String, Object>> update(@PathVariable(value="instanceId") String instanceId) {
        HashMap body = new HashMap();
        return ResponseEntity.ok(body);
    }

    @DeleteMapping
    public ResponseEntity<?> deprovisioning(@PathVariable(value="instanceId") String instanceId) {
        log.info("Deprovisioning instanceId={}", (Object)instanceId);
        HashMap body = new HashMap();
        String name = "cf_" + instanceId;
        return this.cloudKarafkaClient.findByName(name).map(i -> {
            this.cloudKarafkaClient.deleteInstance(i.getId());
            return ResponseEntity.ok((Object)body);
        }).orElseGet(() -> ResponseEntity.status((HttpStatus)HttpStatus.GONE).body((Object)body));
    }
}

