/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.jar;

import java.nio.charset.StandardCharsets;
import org.springframework.boot.loader.jar.StringSequence;

final class AsciiBytes {
    private static final int[] EXCESS = new int[]{0, 4224, 150, 29892736};
    private final byte[] bytes;
    private final int offset;
    private final int length;
    private String string;
    private int hash;

    AsciiBytes(String string) {
        this(string.getBytes(StandardCharsets.UTF_8));
        this.string = string;
    }

    AsciiBytes(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    AsciiBytes(byte[] bytes, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > bytes.length) {
            throw new IndexOutOfBoundsException();
        }
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public int length() {
        return this.length;
    }

    public boolean startsWith(AsciiBytes prefix) {
        if (this == prefix) {
            return true;
        }
        if (prefix.length > this.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (this.bytes[i + this.offset] == prefix.bytes[i + prefix.offset]) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(AsciiBytes postfix) {
        if (this == postfix) {
            return true;
        }
        if (postfix.length > this.length) {
            return false;
        }
        for (int i = 0; i < postfix.length; ++i) {
            if (this.bytes[this.offset + (this.length - 1) - i] == postfix.bytes[postfix.offset + (postfix.length - 1) - i]) continue;
            return false;
        }
        return true;
    }

    public AsciiBytes substring(int beginIndex) {
        return this.substring(beginIndex, this.length);
    }

    public AsciiBytes substring(int beginIndex, int endIndex) {
        int length = endIndex - beginIndex;
        if (this.offset + length > this.bytes.length) {
            throw new IndexOutOfBoundsException();
        }
        return new AsciiBytes(this.bytes, this.offset + beginIndex, length);
    }

    public String toString() {
        if (this.string == null) {
            this.string = new String(this.bytes, this.offset, this.length, StandardCharsets.UTF_8);
        }
        return this.string;
    }

    public boolean matches(CharSequence name, char suffix) {
        int charIndex = 0;
        int nameLen = name.length();
        int totalLen = nameLen + (suffix == '\u0000' ? 0 : 1);
        for (int i = this.offset; i < this.offset + this.length; ++i) {
            int b = this.bytes[i];
            if (b < 0) {
                int limit = this.getRemainingUtfBytes(b &= 0x7F);
                for (int j = 0; j < limit; ++j) {
                    b = (b << 6) + (this.bytes[++i] & 0xFF);
                }
                b -= EXCESS[limit];
            }
            char c = this.getChar(name, suffix, charIndex++);
            if (b <= 65535) {
                if (c == b) continue;
                return false;
            }
            if (c != (b >> 10) + 55232) {
                return false;
            }
            if ((c = this.getChar(name, suffix, charIndex++)) == (b & 0x3FF) + 56320) continue;
            return false;
        }
        return charIndex == totalLen;
    }

    private char getChar(CharSequence name, char suffix, int index) {
        if (index < name.length()) {
            return name.charAt(index);
        }
        if (index == name.length()) {
            return suffix;
        }
        return '\u0000';
    }

    public int hashCode() {
        int hash = this.hash;
        if (hash == 0 && this.bytes.length > 0) {
            for (int i = this.offset; i < this.offset + this.length; ++i) {
                int b = this.bytes[i];
                if (b < 0) {
                    int limit = this.getRemainingUtfBytes(b &= 0x7F);
                    for (int j = 0; j < limit; ++j) {
                        b = (b << 6) + (this.bytes[++i] & 0xFF);
                    }
                    b -= EXCESS[limit];
                }
                if (b <= 65535) {
                    hash = 31 * hash + b;
                    continue;
                }
                hash = 31 * hash + ((b >> 10) + 55232);
                hash = 31 * hash + ((b & 0x3FF) + 56320);
            }
            this.hash = hash;
        }
        return hash;
    }

    private int getRemainingUtfBytes(int b) {
        return b < 96 ? 1 : (b < 112 ? 2 : 3);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj.getClass() == AsciiBytes.class) {
            AsciiBytes other = (AsciiBytes)obj;
            if (this.length == other.length) {
                for (int i = 0; i < this.length; ++i) {
                    if (this.bytes[this.offset + i] == other.bytes[other.offset + i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    static String toString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static int hashCode(CharSequence charSequence) {
        if (charSequence instanceof StringSequence) {
            return charSequence.hashCode();
        }
        return charSequence.toString().hashCode();
    }

    public static int hashCode(int hash, char suffix) {
        return suffix == '\u0000' ? hash : 31 * hash + suffix;
    }
}

