/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.launch;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.tools.ant.launch.AntMain;
import org.apache.tools.ant.launch.LaunchException;
import org.apache.tools.ant.launch.Locator;

public class Launcher {
    public static final String ANTHOME_PROPERTY = "ant.home";
    public static final String USER_LIBDIR = ".ant/lib";
    public static final String MAIN_CLASS = "org.apache.tools.ant.Main";

    public static void main(String[] args) {
        try {
            Launcher launcher = new Launcher();
            launcher.run(args);
        }
        catch (LaunchException e) {
            System.err.println(e.getMessage());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void run(String[] args) throws LaunchException, MalformedURLException {
        StringBuffer baseClassPath;
        String antHomeProperty = System.getProperty(ANTHOME_PROPERTY);
        File antHome = null;
        File sourceJar = Locator.getClassSource(this.getClass());
        File jarDir = sourceJar.getParentFile();
        if (antHomeProperty != null) {
            antHome = new File(antHomeProperty);
        }
        if (antHome == null || !antHome.exists()) {
            antHome = jarDir.getParentFile();
            System.setProperty(ANTHOME_PROPERTY, antHome.getAbsolutePath());
        }
        if (!antHome.exists()) {
            throw new LaunchException("Ant home is set incorrectly or ant could not be located");
        }
        ArrayList<String> libPaths = new ArrayList<String>();
        ArrayList<String> argList = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-lib")) {
                if (i == args.length - 1) {
                    throw new LaunchException("The -lib argument must be followed by a library location");
                }
                libPaths.add(args[++i]);
            } else {
                argList.add(args[i]);
            }
            ++i;
        }
        String[] newArgs = libPaths.size() == 0 ? args : argList.toArray(new String[0]);
        ArrayList<URL> libPathURLs = new ArrayList<URL>();
        Iterator i2 = libPaths.iterator();
        while (i2.hasNext()) {
            String libPath = (String)i2.next();
            StringTokenizer myTokenizer = new StringTokenizer(libPath, System.getProperty("path.separator"));
            while (myTokenizer.hasMoreElements()) {
                File element = new File(myTokenizer.nextToken());
                if (element.isDirectory()) {
                    URL[] dirURLs = Locator.getLocationURLs(element);
                    int j = 0;
                    while (j < dirURLs.length) {
                        libPathURLs.add(dirURLs[j]);
                        ++j;
                    }
                }
                libPathURLs.add(element.toURL());
            }
        }
        URL[] libJars = libPathURLs.toArray(new URL[0]);
        File toolsJar = Locator.getToolsJar();
        URL[] systemJars = Locator.getLocationURLs(jarDir);
        File userLibDir = new File(System.getProperty("user.home"), USER_LIBDIR);
        URL[] userJars = Locator.getLocationURLs(userLibDir);
        int numJars = libJars.length + userJars.length + systemJars.length;
        if (toolsJar != null) {
            ++numJars;
        }
        URL[] jars = new URL[numJars];
        System.arraycopy(libJars, 0, jars, 0, libJars.length);
        System.arraycopy(userJars, 0, jars, libJars.length, userJars.length);
        System.arraycopy(systemJars, 0, jars, userJars.length + libJars.length, systemJars.length);
        if (toolsJar != null) {
            jars[jars.length - 1] = toolsJar.toURL();
        }
        if ((baseClassPath = new StringBuffer(System.getProperty("java.class.path"))).charAt(baseClassPath.length() - 1) == File.pathSeparatorChar) {
            baseClassPath.setLength(baseClassPath.length() - 1);
        }
        int i3 = 0;
        while (i3 < jars.length) {
            baseClassPath.append(File.pathSeparatorChar);
            baseClassPath.append(Locator.fromURI(jars[i3].toString()));
            ++i3;
        }
        System.setProperty("java.class.path", baseClassPath.toString());
        URLClassLoader loader = new URLClassLoader(jars);
        Thread.currentThread().setContextClassLoader(loader);
        try {
            Class<?> mainClass = loader.loadClass(MAIN_CLASS);
            AntMain main = (AntMain)mainClass.newInstance();
            main.startAnt(newArgs, null, null);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

