/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import netrexx.lang.Rexx;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class NetRexxC
extends MatchingTask {
    private boolean binary;
    private String classpath;
    private boolean comments;
    private boolean compact;
    private boolean compile = true;
    private boolean console;
    private boolean crossref;
    private boolean decimal = true;
    private File destDir;
    private boolean diag;
    private boolean explicit;
    private boolean format;
    private boolean java;
    private boolean keep;
    private boolean logo = true;
    private boolean replace;
    private boolean savelog;
    private File srcDir;
    private boolean sourcedir = true;
    private boolean strictargs;
    private boolean strictassign;
    private boolean strictcase;
    private boolean strictimport;
    private boolean strictprops;
    private boolean strictsignal;
    private boolean symbols;
    private boolean time;
    private String trace = "trace2";
    private boolean utf8;
    private String verbose = "verbose3";
    private Vector compileList = new Vector();
    private Hashtable filecopyList = new Hashtable();
    private String oldClasspath = System.getProperty("java.class.path");

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public void setComments(boolean comments) {
        this.comments = comments;
    }

    public void setCompact(boolean compact) {
        this.compact = compact;
    }

    public void setCompile(boolean compile) {
        this.compile = compile;
        if (!this.compile && !this.keep) {
            this.keep = true;
        }
    }

    public void setConsole(boolean console) {
        this.console = console;
    }

    public void setCrossref(boolean crossref) {
        this.crossref = crossref;
    }

    public void setDecimal(boolean decimal) {
        this.decimal = decimal;
    }

    public void setDestDir(File destDirName) {
        this.destDir = destDirName;
    }

    public void setDiag(boolean diag) {
        this.diag = diag;
    }

    public void setExplicit(boolean explicit) {
        this.explicit = explicit;
    }

    public void setFormat(boolean format) {
        this.format = format;
    }

    public void setJava(boolean java) {
        this.java = java;
    }

    public void setKeep(boolean keep) {
        this.keep = keep;
    }

    public void setLogo(boolean logo) {
        this.logo = logo;
    }

    public void setReplace(boolean replace) {
        this.replace = replace;
    }

    public void setSavelog(boolean savelog) {
        this.savelog = savelog;
    }

    public void setSourcedir(boolean sourcedir) {
        this.sourcedir = sourcedir;
    }

    public void setSrcDir(File srcDirName) {
        this.srcDir = srcDirName;
    }

    public void setStrictargs(boolean strictargs) {
        this.strictargs = strictargs;
    }

    public void setStrictassign(boolean strictassign) {
        this.strictassign = strictassign;
    }

    public void setStrictcase(boolean strictcase) {
        this.strictcase = strictcase;
    }

    public void setStrictimport(boolean strictimport) {
        this.strictimport = strictimport;
    }

    public void setStrictprops(boolean strictprops) {
        this.strictprops = strictprops;
    }

    public void setStrictsignal(boolean strictsignal) {
        this.strictsignal = strictsignal;
    }

    public void setSymbols(boolean symbols) {
        this.symbols = symbols;
    }

    public void setTime(boolean time) {
        this.time = time;
    }

    public void setTrace(String trace) {
        if (!(trace.equalsIgnoreCase("trace") || trace.equalsIgnoreCase("trace1") || trace.equalsIgnoreCase("trace2") || trace.equalsIgnoreCase("notrace"))) {
            throw new BuildException("Unknown trace value specified: '" + trace + "'");
        }
        this.trace = trace;
    }

    public void setUtf8(boolean utf8) {
        this.utf8 = utf8;
    }

    public void setVerbose(String verbose) {
        this.verbose = verbose;
    }

    public void execute() throws BuildException {
        if (this.srcDir == null || this.destDir == null) {
            throw new BuildException("srcDir and destDir attributes must be set!");
        }
        DirectoryScanner ds = this.getDirectoryScanner(this.srcDir);
        String[] files = ds.getIncludedFiles();
        this.scanDir(this.srcDir, this.destDir, files);
        this.copyFilesToDestination();
        if (this.compileList.size() > 0) {
            this.log("Compiling " + this.compileList.size() + " source file" + (this.compileList.size() == 1 ? "" : "s") + " to " + this.destDir);
            this.doNetRexxCompile();
        }
    }

    private void scanDir(File srcDir, File destDir, String[] files) {
        int i = 0;
        while (i < files.length) {
            File srcFile = new File(srcDir, files[i]);
            File destFile = new File(destDir, files[i]);
            String filename = files[i];
            if (filename.toLowerCase().endsWith(".nrx")) {
                File classFile = new File(destDir, filename.substring(0, filename.lastIndexOf(46)) + ".class");
                if (!this.compile || srcFile.lastModified() > classFile.lastModified()) {
                    this.filecopyList.put(srcFile.getAbsolutePath(), destFile.getAbsolutePath());
                    this.compileList.addElement(destFile.getAbsolutePath());
                }
            } else if (srcFile.lastModified() > destFile.lastModified()) {
                this.filecopyList.put(srcFile.getAbsolutePath(), destFile.getAbsolutePath());
            }
            ++i;
        }
    }

    private void copyFilesToDestination() {
        if (this.filecopyList.size() > 0) {
            this.log("Copying " + this.filecopyList.size() + " file" + (this.filecopyList.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            Enumeration enumeration = this.filecopyList.keys();
            while (enumeration.hasMoreElements()) {
                String fromFile = (String)enumeration.nextElement();
                String toFile = (String)this.filecopyList.get(fromFile);
                try {
                    ((ProjectComponent)this).project.copyFile(fromFile, toFile);
                }
                catch (IOException ioe) {
                    String msg = "Failed to copy " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
                    throw new BuildException(msg, (Throwable)ioe);
                }
            }
        }
    }

    private void doNetRexxCompile() throws BuildException {
        this.log("Using NetRexx compiler", 3);
        String classpath = this.getCompileClasspath();
        StringBuffer compileOptions = new StringBuffer();
        StringBuffer fileList = new StringBuffer();
        String[] compileOptionsArray = this.getCompileOptionsAsArray();
        String[] fileListArray = new String[this.compileList.size()];
        Enumeration e = this.compileList.elements();
        int j = 0;
        while (e.hasMoreElements()) {
            fileListArray[j] = (String)e.nextElement();
            ++j;
        }
        String[] compileArgs = new String[compileOptionsArray.length + fileListArray.length];
        int i = 0;
        while (i < compileOptionsArray.length) {
            compileArgs[i] = compileOptionsArray[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < fileListArray.length) {
            compileArgs[i2 + compileOptionsArray.length] = fileListArray[i2];
            ++i2;
        }
        compileOptions.append("Compilation args: ");
        int i3 = 0;
        while (i3 < compileOptionsArray.length) {
            compileOptions.append(compileOptionsArray[i3]);
            compileOptions.append(" ");
            ++i3;
        }
        this.log(compileOptions.toString(), 3);
        String eol = System.getProperty("line.separator");
        StringBuffer niceSourceList = new StringBuffer("Files to be compiled:" + eol);
        int i4 = 0;
        while (i4 < this.compileList.size()) {
            niceSourceList.append("    ");
            niceSourceList.append(this.compileList.elementAt(i4).toString());
            niceSourceList.append(eol);
            ++i4;
        }
        this.log(niceSourceList.toString(), 3);
        String currentClassPath = System.getProperty("java.class.path");
        Properties currentProperties = System.getProperties();
        ((Hashtable)currentProperties).put("java.class.path", classpath);
        try {
            StringWriter out = new StringWriter();
            int rc = COM.ibm.netrexx.process.NetRexxC.main((Rexx)new Rexx(compileArgs), (PrintWriter)new PrintWriter(out));
            if (rc > 1) {
                this.log(out.toString(), 0);
                String msg = "Compile failed, messages should have been provided.";
                throw new BuildException(msg);
            }
            if (rc == 1) {
                this.log(out.toString(), 1);
            } else {
                this.log(out.toString(), 2);
            }
            Object var21_20 = null;
        }
        catch (Throwable throwable) {
            Object var21_21 = null;
            currentProperties = System.getProperties();
            ((Hashtable)currentProperties).put("java.class.path", currentClassPath);
            throw throwable;
        }
        currentProperties = System.getProperties();
        ((Hashtable)currentProperties).put("java.class.path", currentClassPath);
    }

    private String getCompileClasspath() {
        StringBuffer classpath = new StringBuffer();
        classpath.append(this.destDir.getAbsolutePath());
        if (this.classpath != null) {
            this.addExistingToClasspath(classpath, this.classpath);
        }
        return classpath.toString();
    }

    private String[] getCompileOptionsAsArray() {
        Vector<String> options = new Vector<String>();
        options.addElement(this.binary ? "-binary" : "-nobinary");
        options.addElement(this.comments ? "-comments" : "-nocomments");
        options.addElement(this.compile ? "-compile" : "-nocompile");
        options.addElement(this.compact ? "-compact" : "-nocompact");
        options.addElement(this.console ? "-console" : "-noconsole");
        options.addElement(this.crossref ? "-crossref" : "-nocrossref");
        options.addElement(this.decimal ? "-decimal" : "-nodecimal");
        options.addElement(this.diag ? "-diag" : "-nodiag");
        options.addElement(this.explicit ? "-explicit" : "-noexplicit");
        options.addElement(this.format ? "-format" : "-noformat");
        options.addElement(this.keep ? "-keep" : "-nokeep");
        options.addElement(this.logo ? "-logo" : "-nologo");
        options.addElement(this.replace ? "-replace" : "-noreplace");
        options.addElement(this.savelog ? "-savelog" : "-nosavelog");
        options.addElement(this.sourcedir ? "-sourcedir" : "-nosourcedir");
        options.addElement(this.strictargs ? "-strictargs" : "-nostrictargs");
        options.addElement(this.strictassign ? "-strictassign" : "-nostrictassign");
        options.addElement(this.strictcase ? "-strictcase" : "-nostrictcase");
        options.addElement(this.strictimport ? "-strictimport" : "-nostrictimport");
        options.addElement(this.strictprops ? "-strictprops" : "-nostrictprops");
        options.addElement(this.strictsignal ? "-strictsignal" : "-nostrictsignal");
        options.addElement(this.symbols ? "-symbols" : "-nosymbols");
        options.addElement(this.time ? "-time" : "-notime");
        options.addElement("-" + this.trace);
        options.addElement(this.utf8 ? "-utf8" : "-noutf8");
        options.addElement("-" + this.verbose);
        Object[] results = new String[options.size()];
        options.copyInto(results);
        return results;
    }

    private void addExistingToClasspath(StringBuffer target, String source) {
        StringTokenizer tok = new StringTokenizer(source, System.getProperty("path.separator"), false);
        while (tok.hasMoreTokens()) {
            File f = ((ProjectComponent)this).project.resolveFile(tok.nextToken());
            if (f.exists()) {
                target.append(File.pathSeparator);
                target.append(f.getAbsolutePath());
                continue;
            }
            this.log("Dropping from classpath: " + f.getAbsolutePath(), 3);
        }
    }
}

