/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.CharFormatter;

class JavaCharFormatter
implements CharFormatter {
    public String escapeChar(int n, boolean bl) {
        switch (n) {
            case 10: {
                return "\\n";
            }
            case 9: {
                return "\\t";
            }
            case 13: {
                return "\\r";
            }
            case 92: {
                return "\\\\";
            }
            case 39: {
                if (bl) {
                    return "\\'";
                }
                return "'";
            }
            case 34: {
                if (bl) {
                    return "\"";
                }
                return "\\\"";
            }
        }
        if (n < 32 || n > 126) {
            if (n >= 0 && n <= 15) {
                return "\\u000" + Integer.toString(n, 16);
            }
            if (n >= 16 && n <= 255) {
                return "\\u00" + Integer.toString(n, 16);
            }
            if (n >= 256 && n <= 4095) {
                return "\\u0" + Integer.toString(n, 16);
            }
            return "\\u" + Integer.toString(n, 16);
        }
        return String.valueOf((char)n);
    }

    public String escapeString(String string) {
        String string2 = new String();
        int n = 0;
        while (n < string.length()) {
            string2 = String.valueOf(string2) + this.escapeChar(string.charAt(n), false);
            ++n;
        }
        return string2;
    }

    public String literalChar(int n) {
        return "'" + this.escapeChar(n, true) + "'";
    }

    public String literalString(String string) {
        return "\"" + this.escapeString(string) + "\"";
    }

    JavaCharFormatter() {
    }
}

