/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.generator.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.apache.ws.jaxme.generator.Generator;
import org.apache.ws.jaxme.generator.SchemaReader;
import org.apache.ws.jaxme.generator.sg.SchemaSG;
import org.apache.ws.jaxme.logging.Logger;
import org.apache.ws.jaxme.logging.LoggerAccess;
import org.xml.sax.InputSource;

public class GeneratorImpl
implements Generator {
    private static final Logger log = LoggerAccess.getLogger((Class)(class$org$apache$ws$jaxme$generator$impl$GeneratorImpl == null ? (class$org$apache$ws$jaxme$generator$impl$GeneratorImpl = GeneratorImpl.class$("org.apache.ws.jaxme.generator.impl.GeneratorImpl")) : class$org$apache$ws$jaxme$generator$impl$GeneratorImpl));
    private SchemaReader schemaReader;
    private File targetDirectory;
    private Map properties = new HashMap();
    private int nextKey;
    private boolean isValidating;
    private boolean isForcingOverwrite;
    private boolean isSettingReadOnly;
    static /* synthetic */ Class class$org$apache$ws$jaxme$generator$impl$GeneratorImpl;

    public boolean isForcingOverwrite() {
        return this.isForcingOverwrite;
    }

    public void setForcingOverwrite(boolean pIsForcingOverwrite) {
        this.isForcingOverwrite = pIsForcingOverwrite;
    }

    public boolean isSettingReadOnly() {
        return this.isSettingReadOnly;
    }

    public void setSettingReadOnly(boolean pIsSettingReadOnly) {
        this.isSettingReadOnly = pIsSettingReadOnly;
    }

    public boolean isValidating() {
        return this.isValidating;
    }

    public void setValidating(boolean pIsValidating) {
        this.isValidating = pIsValidating;
    }

    public void setSchemaReader(SchemaReader pReader) {
        this.schemaReader = pReader;
    }

    public SchemaReader getSchemaReader() {
        return this.schemaReader;
    }

    public void setTargetDirectory(File pDirectory) {
        this.targetDirectory = pDirectory;
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public SchemaSG generate(InputSource pSource) throws Exception {
        SchemaReader sr = this.getSchemaReader();
        sr.setGenerator(this);
        SchemaSG s = sr.parse(pSource);
        s.generate();
        File targetDir = this.getTargetDirectory();
        s.getJavaSourceFactory().write(targetDir);
        return s;
    }

    public SchemaSG generate(File pFile) throws Exception {
        String mName = "generate(File)";
        log.finer("generate(File)", "->", (Object)pFile);
        String path = pFile.getAbsolutePath();
        if (!pFile.exists()) {
            throw new FileNotFoundException("File does not exist: " + path);
        }
        if (!pFile.isFile()) {
            throw new FileNotFoundException("Not a file: " + path);
        }
        InputSource isource = new InputSource(new FileInputStream(pFile));
        isource.setSystemId(pFile.toURL().toString());
        SchemaSG s = this.generate(isource);
        log.finer("generate(File)", "<-", (Object)s);
        return s;
    }

    public SchemaSG generate(URL pURL) throws Exception {
        String mName = "generate(URL)";
        log.entering("generate(URL)", (Object)pURL);
        URLConnection conn = pURL.openConnection();
        InputSource isource = new InputSource(conn.getInputStream());
        isource.setSystemId(pURL.toString());
        SchemaSG s = this.generate(isource);
        log.exiting("generate(URL)", (Object)s);
        return s;
    }

    public String getProperty(String pName) {
        return (String)this.properties.get(pName);
    }

    public String getProperty(String pName, String pDefault) {
        String result = (String)this.properties.get(pName);
        return result == null ? pDefault : result;
    }

    public void setProperty(String pName, String pValue) {
        this.properties.put(pName, pValue);
    }

    public String getKey() {
        return Integer.toString(this.nextKey++);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

