/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.impl;

import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import org.apache.ws.jaxme.JMHandler;
import org.apache.ws.jaxme.JMUnmarshaller;
import org.apache.ws.jaxme.Observer;
import org.apache.ws.jaxme.impl.AtomicHandler;
import org.apache.ws.jaxme.impl.JAXBContextImpl;
import org.apache.ws.jaxme.impl.ValidationEventImpl;
import org.apache.ws.jaxme.util.NamespaceSupport;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class JMHandlerBase
implements JMHandler {
    private Locator locator;
    private JMHandler.Data data;
    private Observer observer;

    public void init(JMUnmarshaller pUnmarshaller) throws JAXBException {
        this.init(new DataImpl(pUnmarshaller));
    }

    public void init(JMHandler.Data pData) throws JAXBException {
        this.data = pData;
    }

    public JMHandler.Data getData() {
        return this.data;
    }

    public void setDocumentLocator(Locator pLocator) {
        this.locator = pLocator;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    public void setObserver(Observer pObserver) {
        this.observer = pObserver;
    }

    public Observer getObserver() {
        return this.observer;
    }

    protected void validationEvent(int pSeverity, String pMsg, String pErrorCode) throws SAXException {
        ValidationEventHandler eventHandler;
        try {
            eventHandler = this.getData().getUnmarshaller().getEventHandler();
        }
        catch (JAXBException e) {
            throw new SAXException((Exception)((Object)e));
        }
        if (eventHandler == null) {
            throw new SAXParseException(pMsg, this.getDocumentLocator());
        }
        ValidationEventLocatorImpl myLocator = new ValidationEventLocatorImpl(this.getDocumentLocator());
        ValidationEventImpl event = new ValidationEventImpl(pSeverity, pErrorCode + ": " + pMsg, (ValidationEventLocator)myLocator);
        event.setErrorCode(pErrorCode);
        eventHandler.handleEvent((ValidationEvent)event);
    }

    protected void validationEvent(int pSeverity, String pMsg, String pErrorCode, Exception pException) throws SAXException {
        ValidationEventHandler eventHandler;
        try {
            eventHandler = this.getData().getUnmarshaller().getEventHandler();
        }
        catch (JAXBException e) {
            throw new SAXException((Exception)((Object)e));
        }
        if (eventHandler == null) {
            throw new SAXParseException(pMsg, this.getDocumentLocator(), pException);
        }
        ValidationEventLocatorImpl myLocator = new ValidationEventLocatorImpl(this.getDocumentLocator());
        ValidationEventImpl event = new ValidationEventImpl(pSeverity, pErrorCode + ": " + pMsg, (ValidationEventLocator)myLocator, pException);
        event.setErrorCode(pErrorCode);
        eventHandler.handleEvent((ValidationEvent)event);
    }

    public void processingInstruction(String pTarget, String pData) throws SAXException {
        this.validationEvent(0, "Don't know how to handle processing instructions.", "JM_EVENT_PROCESSING_INSTRUCTION");
    }

    public void skippedEntity(String name) throws SAXException {
        this.validationEvent(0, "Don't know how to handle skipped entities.", "JM_EVENT_SKIPPED_ENTITY");
    }

    public void startPrefixMapping(String pPrefix, String pURI) throws SAXException {
        this.getData().getNamespaceContext().declarePrefix(pPrefix, pURI);
    }

    public void endPrefixMapping(String pPrefix) throws SAXException {
        this.getData().getNamespaceContext().undeclarePrefix(pPrefix);
    }

    public void endDocument() {
        Observer o = this.getObserver();
        if (o != null) {
            o.notify(this.getResult());
        }
    }

    protected class DataImpl
    implements JMHandler.Data {
        private JMUnmarshaller unmarshaller;
        private AtomicHandler atomicHandler;
        private NamespaceSupport namespaceSupport = new NamespaceSupport();

        public DataImpl(JMUnmarshaller pUnmarshaller) {
            this.unmarshaller = pUnmarshaller;
        }

        public JMUnmarshaller getUnmarshaller() {
            return this.unmarshaller;
        }

        public JAXBContextImpl getFactory() {
            return this.unmarshaller.getJAXBContextImpl();
        }

        public JMHandler getAtomicHandler() {
            if (this.atomicHandler == null) {
                this.atomicHandler = new AtomicHandler();
            }
            return this.atomicHandler;
        }

        public DatatypeConverterInterface getDatatypeConverter() {
            return this.unmarshaller.getDatatypeConverter();
        }

        public NamespaceSupport getNamespaceContext() {
            return this.namespaceSupport;
        }
    }
}

