/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.util;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DOMSerializer {
    private boolean namespaceDeclarationAttribute;
    private boolean parentsNamespaceDeclarationDisabled;

    public void setNamespaceDeclarationAttribute(boolean pXmlDeclarationAttribute) {
        this.namespaceDeclarationAttribute = pXmlDeclarationAttribute;
    }

    public boolean isNamespaceDeclarationAttribute() {
        return this.namespaceDeclarationAttribute;
    }

    public void setParentsNamespaceDeclarationDisabled(boolean pParentsXmlDeclarationDisabled) {
        this.parentsNamespaceDeclarationDisabled = pParentsXmlDeclarationDisabled;
    }

    public boolean isParentsNamespaceDeclarationDisabled() {
        return this.parentsNamespaceDeclarationDisabled;
    }

    protected void doSerializeChilds(Node pNode, ContentHandler pHandler) throws SAXException {
        for (Node child = pNode.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.doSerialize(child, pHandler);
        }
    }

    protected void parentsStartPrefixMappingEvents(Node pNode, ContentHandler pHandler) throws SAXException {
        if (pNode != null) {
            this.parentsStartPrefixMappingEvents(pNode.getParentNode(), pHandler);
            if (pNode.getNodeType() == 1) {
                this.startPrefixMappingEvents(pNode, pHandler);
            }
        }
    }

    protected void parentsEndPrefixMappingEvents(Node pNode, ContentHandler pHandler) throws SAXException {
        if (pNode != null) {
            if (pNode.getNodeType() == 1) {
                this.endPrefixMappingEvents(pNode, pHandler);
            }
            this.parentsEndPrefixMappingEvents(pNode.getParentNode(), pHandler);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void startPrefixMappingEvents(Node pNode, ContentHandler pHandler) throws SAXException {
        NamedNodeMap nnm = pNode.getAttributes();
        if (nnm != null) {
            for (int i = 0; i < nnm.getLength(); ++i) {
                void var6_6;
                String prefix;
                Node attr = nnm.item(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
                if ("xmlns".equals(attr.getPrefix())) {
                    prefix = attr.getLocalName();
                } else if ("xmlns".equals(attr.getNodeName())) {
                    prefix = "";
                } else {
                    throw new IllegalStateException("Unable to parse namespace declaration: " + attr.getNodeName());
                }
                String uri = attr.getNodeValue();
                if (uri == null) {
                    uri = "";
                }
                pHandler.startPrefixMapping((String)var6_6, uri);
            }
        }
    }

    protected void endPrefixMappingEvents(Node pNode, ContentHandler pHandler) throws SAXException {
        NamedNodeMap nnm = pNode.getAttributes();
        if (nnm != null) {
            for (int i = nnm.getLength() - 1; i >= 0; --i) {
                Node attr = nnm.item(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
                String prefix = attr.getLocalName();
                pHandler.endPrefixMapping(prefix);
            }
        }
    }

    public void serialize(Node pNode, ContentHandler pHandler) throws SAXException {
        if (!this.isNamespaceDeclarationAttribute() && !this.isParentsNamespaceDeclarationDisabled()) {
            this.parentsStartPrefixMappingEvents(pNode.getParentNode(), pHandler);
        }
        this.doSerialize(pNode, pHandler);
        if (!this.isNamespaceDeclarationAttribute() && !this.isParentsNamespaceDeclarationDisabled()) {
            this.parentsEndPrefixMappingEvents(pNode.getParentNode(), pHandler);
        }
    }

    protected void doSerialize(Node pNode, ContentHandler pHandler) throws SAXException {
        switch (pNode.getNodeType()) {
            case 9: {
                pHandler.startDocument();
                this.doSerializeChilds(pNode, pHandler);
                pHandler.endDocument();
                break;
            }
            case 11: {
                this.doSerializeChilds(pNode, pHandler);
                break;
            }
            case 1: {
                NamedNodeMap nnm;
                AttributesImpl attr = new AttributesImpl();
                boolean isNamespaceDeclarationAttribute = this.isNamespaceDeclarationAttribute();
                if (!isNamespaceDeclarationAttribute) {
                    this.startPrefixMappingEvents(pNode, pHandler);
                }
                if ((nnm = pNode.getAttributes()) != null) {
                    for (int i = 0; i < nnm.getLength(); ++i) {
                        Node a = nnm.item(i);
                        if (!isNamespaceDeclarationAttribute && "http://www.w3.org/2000/xmlns/".equals(a.getNamespaceURI())) continue;
                        attr.addAttribute(a.getNamespaceURI(), a.getNodeName(), a.getLocalName(), "CDATA", a.getNodeValue());
                    }
                }
                pHandler.startElement(pNode.getNamespaceURI(), pNode.getLocalName(), pNode.getNodeName(), attr);
                this.doSerializeChilds(pNode, pHandler);
                pHandler.endElement(pNode.getNamespaceURI(), pNode.getLocalName(), pNode.getNodeName());
                if (isNamespaceDeclarationAttribute) break;
                this.endPrefixMappingEvents(pNode, pHandler);
                break;
            }
            case 3: 
            case 4: {
                String s = pNode.getNodeValue();
                pHandler.characters(s.toCharArray(), 0, s.length());
                break;
            }
            case 7: {
                pHandler.processingInstruction(pNode.getNodeName(), pNode.getNodeValue());
                break;
            }
            case 5: {
                pHandler.skippedEntity(pNode.getNodeName());
            }
        }
    }
}

