/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.util;

import java.io.Serializable;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;

public class Duration
implements Serializable,
Comparable {
    private final int years;
    private final int months;
    private final int days;
    private final int hours;
    private final int minutes;
    private final double seconds;

    public Duration(int pYears, int pMonths, int pDays, int pHours, int pMinutes, double pSeconds) {
        this.years = pYears;
        this.months = pMonths;
        this.days = pDays;
        this.hours = pHours;
        this.minutes = pMinutes;
        this.seconds = pSeconds;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public double getSeconds() {
        return this.seconds;
    }

    public String toString() {
        return "P" + this.getYears() + "Y" + this.getMonths() + "M" + this.getDays() + "DT" + this.getHours() + "H" + this.getMinutes() + "M" + NumberFormat.getInstance().format(this.getSeconds()) + "S";
    }

    public static Duration valueOf(String pValue) throws ParseException {
        MessageFormat format = new MessageFormat("P{0,number,integer}Y{1,number,integer}M{2,number,integer}DT{3,number,integer}H{4,number,integer}M{5,number}S");
        Object[] numbers = format.parse(pValue);
        return new Duration(((Number)numbers[0]).intValue(), ((Number)numbers[1]).intValue(), ((Number)numbers[2]).intValue(), ((Number)numbers[3]).intValue(), ((Number)numbers[4]).intValue(), ((Number)numbers[5]).doubleValue());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Duration)) {
            return false;
        }
        return this.compareTo((Duration)o) == 0;
    }

    public int compareTo(Object o) {
        return this.compareTo((Duration)o);
    }

    public int compareTo(Duration d) {
        if (this.years != d.years) {
            return this.years - d.years;
        }
        if (this.months != d.months) {
            return this.months - d.months;
        }
        if (this.days != d.days) {
            return this.days - d.days;
        }
        if (this.hours != d.hours) {
            return this.hours - d.hours;
        }
        if (this.minutes != d.minutes) {
            return this.minutes - d.minutes;
        }
        if (this.seconds > d.seconds) {
            return 1;
        }
        if (this.seconds < d.seconds) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        return this.years + this.months + this.days + this.hours + this.minutes + (int)this.seconds;
    }
}

